package com.biz.crm.promotion.service.component.function.impl.fullgift;

import com.biz.crm.promotion.service.component.RuleExecuteParam;
import com.biz.crm.promotion.service.component.function.AbstractConditionRuleFunction;
import com.biz.crm.promotion.service.component.function.param.ConditionRuleParam;
import com.biz.crm.promotion.service.component.function.response.ConditionRuleResponse;
import com.biz.crm.promotion.service.component.resolver.ladder.AbstractConditionRuleLadderResolver;
import com.biz.crm.promotion.service.component.resolver.ladder.LadderResolverHelper;
import com.biz.crm.util.CommonConstant;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.List;


/**
 * 条件规则-数量~数量
 *  @author: luoqi
 *  @Date: 2020-11-26 20:50
 *  @version: V1.0
 *  @Description:
 */
@Component(ConditionNoNo.FUNC_BODY)
public class ConditionNoNo extends AbstractConditionRuleFunction<ConditionRuleParam, ConditionRuleResponse> {
    public static final String FUNC_BODY = "conditionNoNo";
    @Resource
    private LadderResolverHelper ladderResolverHelper;

    @Override
    public ConditionRuleResponse apply(ConditionRuleParam conditionRuleParam) {
        //获取该规则的阶梯解析器
        AbstractConditionRuleLadderResolver ladderResolver = ladderResolverHelper.getResolverByFuncBody(FUNC_BODY);
        //订单内的商品购买明细
        List<RuleExecuteParam.ProductOrderBuy> productOrderBuy = conditionRuleParam.getProductOrderBuy();
        //总数量
        BigDecimal productBuyNo = BigDecimal.ZERO;
        //总金额
//        BigDecimal productBuyAmount = BigDecimal.ZERO;
        //用户设置的阶梯满赠数量单位
        String ladderNoUnit = ladderResolver.unitAsProductCurrentY(conditionRuleParam.getLadder());
        //汇总商品的总购买量
        if(null != productOrderBuy){
            for(RuleExecuteParam.ProductOrderBuy v : productOrderBuy){
                //阶梯配置的销售，不用转换
                /**
                 * 丰谷配置阶梯时固定基本单位，不用转换
                 */
//                if(ProductUnitEnum.material_sale_unit.getValue().equals(ladderNoUnit) && null != v.getUnitConvertor()){
//                    //基本单位转销售单位
//                    BigDecimal converted = v.getProductBuyNo().multiply(v.getUnitConvertor());
//                    productBuyNo = productBuyNo.add(converted);
//                    continue;
//                }
                //阶梯配置的基本单位，不用转换
                productBuyNo = productBuyNo.add(v.getProductBuyNo());
            }
        }
        /**
         * 返回订单购买数量对满赠数量取余结果，计算规则脚本可依据该结果进行灵活的阶梯计算
         */
        ConditionRuleResponse response = this.divideAndRemainder(productBuyNo, ladderResolver.valueAsProductCurrentY(conditionRuleParam.getLadder()));

        //阶梯赠品赠送量数据类型
        response.setResultDataType(CommonConstant.DMS.PRODUCTS_ORDER_QTY_TYPE.NUMBER.getItemCode());
        //阶梯赠品单位配置
        String unitType = ladderResolver.unitAsProductCurrentN(conditionRuleParam.getLadder());
        //阶梯赠品赠送量配置
        response.setGiftValue(ladderResolver.valueAsProductCurrentN(conditionRuleParam.getLadder()));
        response.setResultDataUnitType(unitType);
        return response;
    }
    @Override
    public String getConditionType() {
        return CommonConstant.DMS.PRODUCTS_ORDER_QTY_TYPE.NUMBER.getItemCode();
    }


}
