package com.biz.crm.promotion.service.component.resolver.ladder;

import com.biz.crm.base.BusinessException;
import com.biz.crm.nebular.dms.promotion.PromotionRuleEditVo;
import com.biz.crm.promotion.service.component.resolver.ConditionRuleLadderResolver;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import javax.annotation.PostConstruct;
import java.math.BigDecimal;
import java.util.List;


/**
 * 条件规则阶梯数据解析器 - 抽象
 *  @author: luoqi
 *  @Date: 2021-1-8 16:19
 *  @version: V1.0
 *  @Description:
 */
public abstract class AbstractConditionRuleLadderResolver implements ConditionRuleLadderResolver {
    //规则实例名
    protected String funcBody;
    //阶梯控件下标-本品购买量
    protected Integer valueIndexAsProductCurrentY = 0;
    //阶梯控件下标-本品单位
    protected Integer unitIndexAsProductCurrentY = 1;
    //阶梯控件下标-赠品赠送量
    protected Integer valueIndexAsProductCurrentN = 2;
    //阶梯控件下标-赠品赠送单位
    protected Integer unitIndexAsProductCurrentN = 3;
    //阶梯组件个数
    protected Integer controlSize = 4;


    @PostConstruct
    public void init(){
        Config config = this.config();
        //阶梯控件下标-本品购买量
        this.valueIndexAsProductCurrentY = config.getValueIndexAsProductCurrentY();
        //阶梯控件下标-本品单位
        this.unitIndexAsProductCurrentY = config.getUnitIndexAsProductCurrentY();
        //阶梯控件下标-赠品赠送量
        this.valueIndexAsProductCurrentN = config.getValueIndexAsProductCurrentN();
        //阶梯控件下标-赠品赠送单位
        this.unitIndexAsProductCurrentN = config.getUnitIndexAsProductCurrentN();
        //阶梯组件个数
        this.controlSize = config.getControlSize();
        //规则实例名
        this.funcBody = config.getFuncBody();
    }


    /**
     * 初始化配置
     *  @author: luoqi
     *  @Date: 2021-1-8 16:44
     *  @version: V1.0
     *  @Description:
     */
    protected abstract Config config();

    /**
     * 本品配置量
     *
     * @param controlRow
     * @return
     */
    @Override
    public BigDecimal valueAsProductCurrentY(PromotionRuleEditVo.ControlRow controlRow) {
        this.check(controlRow);
        List<PromotionRuleEditVo.KeyValParamControl> controls = controlRow.getControls();

        //用户设置的阶梯满赠本品量
        Object ladderNo = controls.get(this.valueIndexAsProductCurrentY).getValue();

        if(null == ladderNo || StringUtils.isBlank(ladderNo.toString())){
            throw new BusinessException("规则[" + funcBody + "]阶梯配置错误，请配置阶梯本品满赠量");
        }
        return new BigDecimal(ladderNo.toString());
    }

    /**
     * 本品单位配置
     *
     * @param controlRow
     * @return
     */
    @Override
    public String unitAsProductCurrentY(PromotionRuleEditVo.ControlRow controlRow) {
        this.check(controlRow);
        List<PromotionRuleEditVo.KeyValParamControl> controls = controlRow.getControls();
        //用户设置的阶梯满赠本品数量单位
        Object ladderNoUnit = controls.get(this.unitIndexAsProductCurrentY).getValue();
        if(null == ladderNoUnit || StringUtils.isBlank(ladderNoUnit.toString())){
            throw new BusinessException("规则[" + funcBody + "]阶梯配置错误，请配置阶梯本品满赠数量单位");
        }
        return ladderNoUnit.toString();
    }

    /**
     * 赠品配置量
     *
     * @param controlRow
     * @return
     */
    @Override
    public BigDecimal valueAsProductCurrentN(PromotionRuleEditVo.ControlRow controlRow) {
        this.check(controlRow);
        List<PromotionRuleEditVo.KeyValParamControl> controls = controlRow.getControls();

        //用户设置的阶梯满赠量
        Object ladderNo = controls.get(this.valueIndexAsProductCurrentN).getValue();

        if(null == ladderNo || StringUtils.isBlank(ladderNo.toString())){
            throw new BusinessException("促销政策规则[" + funcBody + "]阶梯配置错误，请配置阶梯赠品量");
        }
        return new BigDecimal(ladderNo.toString());
    }

    /**
     * 赠品单位配置
     *
     * @param controlRow
     * @return
     */
    @Override
    public String unitAsProductCurrentN(PromotionRuleEditVo.ControlRow controlRow) {
        this.check(controlRow);
        List<PromotionRuleEditVo.KeyValParamControl> controls = controlRow.getControls();
        //用户设置的阶梯满赠数量单位
        Object ladderNoUnit = controls.get(this.unitIndexAsProductCurrentN).getValue();
        if(null == ladderNoUnit || StringUtils.isBlank(ladderNoUnit.toString())){
            throw new BusinessException("促销政策规则[" + funcBody + "]阶梯配置错误，赠送形式为“数量”的阶梯必须指定赠品的单位类型(基本单位/销售单位)。");
        }
        return ladderNoUnit.toString();
    }

    /**
     * 获取控件配置的值
     *
     * @param controlRow
     * @param index
     * @return
     */
    @Override
    public Object controlValue(PromotionRuleEditVo.ControlRow controlRow, int index) {
        this.check(controlRow);
        List<PromotionRuleEditVo.KeyValParamControl> controls = controlRow.getControls();
        //用户设置的阶梯满赠数量单位
        Object ladderNoUnit = controls.get(index).getValue();
        if(null == ladderNoUnit || StringUtils.isBlank(ladderNoUnit.toString())){
            throw new BusinessException("促销政策规则[" + funcBody + "][第" + index + "位]参数配置错误，未获取到可用的参数值。");
        }
        return ladderNoUnit;
    }

    /**
     * 获取控件配置的值-默认取第一个
     *
     * @param controlRow
     * @return
     */
    @Override
    public Object controlValue(PromotionRuleEditVo.ControlRow controlRow) {
        return this.controlValue(controlRow, 0);
    }

    protected void check(PromotionRuleEditVo.ControlRow controlRow){
        List<PromotionRuleEditVo.KeyValParamControl> controls = controlRow.getControls();
        if(null == controls || controls.size() != this.controlSize){
            throw new BusinessException("促销政策规则[" + funcBody + "]阶梯控件配置不符规范，请检查。");
        }
    }


    /**
     * 解析器初始化参数
     *  @author: luoqi
     *  @Date: 2021-1-8 16:41
     *  @version: V1.0
     *  @Description:
     */
    @Data
    public static class Config{
        //规则实例名
        private String funcBody;
        //阶梯控件下标-本品购买量
        private Integer valueIndexAsProductCurrentY;
        //阶梯控件下标-本品单位
        private Integer unitIndexAsProductCurrentY ;
        //阶梯控件下标-赠品赠送量
        private Integer valueIndexAsProductCurrentN;
        //阶梯控件下标-赠品赠送单位
        private Integer unitIndexAsProductCurrentN;

        //阶梯组件个数
        private Integer controlSize;
    }
}
