package com.biz.crm.promotion.service.component.resolver.ladder.discount;

import com.biz.crm.promotion.service.component.function.impl.discount.ConditionAmountRatioDiscount;
import com.biz.crm.promotion.service.component.resolver.ladder.AbstractConditionRuleLadderResolver;
import com.biz.crm.promotion.service.component.resolver.ladder.LadderResolverHelper;
import org.springframework.stereotype.Component;

/**
 * @Author: chenrong
 * @Date: 2021/2/23 11:12
 */
@Component(ConditionAmountRatioDiscount.FUNC_BODY + LadderResolverHelper.LADDER_RESOLVER)
public class ConditionRuleAmountRatioDiscountResolver extends AbstractConditionRuleLadderResolver {

  /**
   * 初始化配置
   * @author: luoqi
   * @Date: 2021-1-8 16:44
   * @version: V1.0
   * @Description:
   */
  @Override
  protected Config config() {
    Config config = new Config();
    //阶梯组件个数
    config.setControlSize(2);
    //规则实例名
    config.setFuncBody(ConditionAmountRatioDiscount.FUNC_BODY);
    //阶梯控件下标-本品购买量
    config.setValueIndexAsProductCurrentY(0);
    //阶梯控件下标-本品单位
//    config.setUnitIndexAsProductCurrentY(1);
    //阶梯控件下标-折扣比例
    config.setValueIndexAsProductCurrentN(1);
    //阶梯控件下标-赠品赠送单位
//    config.setUnitIndexAsProductCurrentN(2);
    return config;
  }
}
