package com.biz.crm.promotion.service.component.resolver.ladder.fullgift;

import com.biz.crm.promotion.service.component.function.impl.fullgift.ConditionNoNo;
import com.biz.crm.promotion.service.component.resolver.ladder.AbstractConditionRuleLadderResolver;
import com.biz.crm.promotion.service.component.resolver.ladder.LadderResolverHelper;
import org.springframework.stereotype.Component;


/**
 * 数量数量阶梯解析器
 *  @author: luoqi
 *  @Date: 2021-1-7 14:24
 *  @version: V1.0
 *  @Description:
 */
@Component(ConditionNoNo.FUNC_BODY + LadderResolverHelper.LADDER_RESOLVER)
public class ConditionRuleNoNoLadderResolver extends AbstractConditionRuleLadderResolver {

    /**
     * 初始化配置
     *
     * @author: luoqi
     * @Date: 2021-1-8 16:44
     * @version: V1.0
     * @Description:
     */
    @Override
    protected Config config() {
        Config config = new Config();
        //阶梯组件个数
        config.setControlSize(4);
        //规则名称
        config.setFuncBody(ConditionNoNo.FUNC_BODY);
        //阶梯控件下标-本品购买量
        config.setValueIndexAsProductCurrentY(0);
        //阶梯控件下标-本品单位
        config.setUnitIndexAsProductCurrentY(1);
        //阶梯控件下标-赠品赠送量
        config.setValueIndexAsProductCurrentN(2);
        //阶梯控件下标-赠品赠送单位
        config.setUnitIndexAsProductCurrentN(3);
        return config;
    }
}
