package com.biz.crm.promotion.service.component.resolver.ladder.fullreduce;

import com.biz.crm.promotion.service.component.function.impl.fullreduce.ConditionNoAmountReduce;
import com.biz.crm.promotion.service.component.resolver.ladder.AbstractConditionRuleLadderResolver;
import com.biz.crm.promotion.service.component.resolver.ladder.LadderResolverHelper;
import org.springframework.stereotype.Component;

/**
 * @Author: chenrong
 * @Date: 2021/2/23 11:12
 */
@Component(ConditionNoAmountReduce.FUNC_BODY + LadderResolverHelper.LADDER_RESOLVER)
public class ConditionRuleNoAmountReduceResolver extends AbstractConditionRuleLadderResolver {

  /**
   * 初始化配置
   * @author: luoqi
   * @Date: 2021-1-8 16:44
   * @version: V1.0
   * @Description:
   */
  @Override
  protected Config config() {
    Config config = new Config();
    //阶梯组件个数
    config.setControlSize(3);
    //规则实例名
    config.setFuncBody(ConditionNoAmountReduce.FUNC_BODY);
    //阶梯控件下标-本品购买量
    config.setValueIndexAsProductCurrentY(0);
    //阶梯控件下标-本品单位
    config.setUnitIndexAsProductCurrentY(1);
    //阶梯控件下标-减少金额
    config.setValueIndexAsProductCurrentN(2);
    //阶梯控件下标-赠品赠送单位
//    config.setUnitIndexAsProductCurrentN(2);
    return config;
  }
}
