package com.biz.crm.promotion.service.component.validator.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyEditReqVo;
import com.biz.crm.promotion.mapper.PromotionPolicyMapper;
import com.biz.crm.promotion.service.component.ProductPriceMatcher;
import com.biz.crm.promotion.service.component.resolver.ladder.LadderResolverHelper;
import com.biz.crm.promotion.service.component.validator.PromotionPolicyEditValidator;
import com.biz.crm.util.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;


/**
 * 政策编辑费校验活动行号唯一促销
 *  @author: luoqi
 *  @Date: 2021-1-6 16:47
 *  @version: V1.0
 *  @Description:
 */
@Slf4j
@Component("promotionPolicySingleActivityValidator")
@Order
public class PromotionPolicySingleActivityValidator implements PromotionPolicyEditValidator {

    @Resource
    private PromotionPolicyMapper promotionPolicyMapper;

    /**
     * 校验
     *
     * @param vo
     */
    @Override
    public void validate(PromotionPolicyEditReqVo vo) throws BusinessException {
        if(!StringUtils.isEmpty(vo.getActPlanNo())){
            Integer count = promotionPolicyMapper.countByParam(vo.getActPlanNo(),vo.getId());
            if(count.intValue() > 0){
                throw new BusinessException("一个活动行号只能匹配一个促销");
            }
        }

    }
}
