package com.biz.crm.promotion.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.eunm.dms.PromotionPolicyEunm;
import com.biz.crm.nebular.dms.promotion.*;
import com.biz.crm.promotion.entity.PromotionPolicyProductEntity;
import com.biz.crm.promotion.entity.PromotionPolicyTemplateEntity;
import com.biz.crm.promotion.mapper.PromotionPolicyProductMapper;
import com.biz.crm.promotion.mapper.PromotionPolicyTemplateMapper;
import com.biz.crm.promotion.service.PromotionPolicyProductService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CommonConstant;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.ValidateUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;


/**
 *  @author: luoqi
 *  @Date: 2020-10-15 16:50
 *  @version: V1.0
 *  @Description:
 */
@Transactional
@ConditionalOnMissingBean(name = "promotionPolicyProductServiceExpandImpl")
@Service("promotionPolicyProductService")
public class PromotionPolicyProductServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<PromotionPolicyProductMapper, PromotionPolicyProductEntity> implements PromotionPolicyProductService {

    @Resource
    private PromotionPolicyProductMapper promotionPolicyProductMapper;
    @Resource
    private PromotionPolicyTemplateMapper promotionPolicyTemplateMapper;
    /**
     * @param editVo
     * @author: luoqi
     * @Date: 2020-10-19 16:28
     * @version: V1.0
     * @Description:
     */
    @Override
    public void refreshProduct(PromotionPolicyEditReqVo editVo) {
        //删除旧的促销商品
        if(StringUtils.isNotBlank(editVo.getId())){
            this.doDelByPromotionPolicyIdOrCode(Lists.newArrayList(editVo.getId()), null);
        }
        List<PromotionPolicyProductEditVo> tempEditVos = editVo.takeAllProducts()
                , editVos = Lists.newArrayList();
        if(CollectionUtils.isEmpty(tempEditVos)){
            return;
        }
        PromotionPolicyTemplateEntity templateEntity = this.promotionPolicyTemplateMapper.selectById(editVo.getTemplateId());
        Set<String> keys = Sets.newHashSet();
        for(PromotionPolicyProductEditVo temp : tempEditVos){
            String key = temp.getPromotionPolicyId() + temp.getProductCode() + temp.getCurrentProduct();
            if(keys.contains(key)){
                continue;
            }
            if(!PromotionPolicyEunm.PromotionProductTypeEunm.CURRENT_RELATIONAL_GIFT.getCode().equals(templateEntity.getPromotionProduct())){
                //不是一一对应，不能把赠品配置在本品上
                temp.setProductCodeGift(null);
                temp.setProductNameGift(null);
            }
            temp.setId(null);
            temp.setPromotionPolicyCode(editVo.getPromotionPolicyCode());
            temp.setPromotionPolicyId(editVo.getId());
            temp.setPromotionPolicyName(editVo.getPromotionPolicyName());
            editVos.add(temp);
            keys.add(key);
        }
//        if(!CollectionUtils.isEmpty(editVos)) {
//            ValidateUtils.isTrue(editVos.size() == 1, "只能有一条买赠商品记录");
//        }
        this.saveBatch(CrmBeanUtil.copyList(editVos, PromotionPolicyProductEntity.class));
    }

    /**
     * 加载政策下的促销商品
     *
     * @param editVo
     * @author: luoqi
     * @Date: 2020-10-20 20:47
     * @version: V1.0
     * @Description:
     */
    @Override
    public void loadListForEditPromotionPolicy(PromotionPolicyEditVo editVo) {

        List<PromotionPolicyProductEntity>
                y = null, //本品
                n = null;//赠品
        if(StringUtils.isNotBlank(editVo.getId())){
            QueryWrapper<PromotionPolicyProductEntity> wrapper = Wrappers.query();
            wrapper.in("promotion_policy_id", editVo.getId());
            Map<String, List<PromotionPolicyProductEntity>> groupByCurrentProduct = promotionPolicyProductMapper.selectList(wrapper).stream()
                    .collect(Collectors.groupingBy(PromotionPolicyProductEntity :: getCurrentProduct));
            //本品
            y = groupByCurrentProduct.get(CommonConstant.GLOBAL.YesOrNo.Y.getItemCode());
            //赠品
            n = groupByCurrentProduct.get(CommonConstant.GLOBAL.YesOrNo.N.getItemCode());
        }
        PromotionPolicyProduct promotionPolicyProduct = new PromotionPolicyProduct();
        promotionPolicyProduct.setProductsCurrentY(CrmBeanUtil.copyList(y, PromotionPolicyProductEditVo.class));
        promotionPolicyProduct.setProductsCurrentN(CrmBeanUtil.copyList(n, PromotionPolicyProductEditVo.class));
        editVo.setPromotionPolicyProduct(promotionPolicyProduct);
    }

    /**
     * 按政策id或政策code 批量删除
     *
     * @param promotionPolicyId
     * @param promotionPolicyCode
     * @author: luoqi
     * @Date: 2020-10-20 16:01
     * @version: V1.0
     * @Description:
     */
    @Override
    public void delByPromotionPolicyIdOrCode(List<String> promotionPolicyId, List<String> promotionPolicyCode) {
        this.doDelByPromotionPolicyIdOrCode(promotionPolicyId, promotionPolicyCode);
    }

    /**
     * 查询该商品对应的政策id列表
     *
     * @param productCode
     * @return
     */
    @Override
    public Set<String> selectPromotionPolicyIdByProductCode(String productCode) {
        if(StringUtils.isBlank(productCode)){
            return Sets.newHashSet();
        }
        return Sets.newHashSet(promotionPolicyProductMapper.selectPromotionPolicyIdByProductCode(productCode));
    }

    /**
     * 查询该商品对应的政策列表
     *
     * @param productCodes
     * @return
     */
    @Override
    public List<PromotionPolicyProductEntity> selectPromotionPolicyIdByProductCodes(List<String> productCodes) {
        return promotionPolicyProductMapper.selectPromotionPolicyIdByProductCodes(productCodes);
    }

    /**
     * 查询该商品对应的政策列表
     *
     * @param reqVo
     * @return
     */
    @Override
    public List<PromotionPolicyProductRespVo> selectListByPromotionPolicyCodes(PromotionPolicyCodesVo reqVo) {
        return promotionPolicyProductMapper.selectListByPromotionPolicyCodes(reqVo);
    }

    /**
     * 删除政策下的促销商品
     *  @author: luoqi
     *  @Date: 2020-10-20 11:22
     *  @version: V1.0
     *  @Description:
     */
    private void doDelByPromotionPolicyIdOrCode(List<String> promotionPolicyId, List<String> promotionPolicyCode){
        QueryWrapper<PromotionPolicyProductEntity> wrapper = Wrappers.query();
        if(!CollectionUtils.isEmpty(promotionPolicyId)){
            wrapper.in("promotion_policy_id", promotionPolicyId);
        }else if(!CollectionUtils.isEmpty(promotionPolicyCode)){
            wrapper.in("promotion_policy_code", promotionPolicyCode);
        }else{
            return;
        }
        promotionPolicyProductMapper.delete(wrapper);
    }


    /**
     * 查询政策的商品列表
     *
     * @return
     */
    @Override
    public void selectGiftByPromotionPolicyId(LoadConfigInfoContext loadConfigInfoContext, String isCurrentProduct) {
        Set<String> promotionPolicyIds = loadConfigInfoContext.getPromotionPolicyIds();
        if(CollectionUtils.isEmpty(promotionPolicyIds) || StringUtils.isBlank(isCurrentProduct)){
            return ;
        }

        //查询本品或赠品
        List<PromotionPolicyProductEntity> entities = promotionPolicyProductMapper.selectList(Wrappers.lambdaQuery(PromotionPolicyProductEntity.class)
                .eq(PromotionPolicyProductEntity :: getCurrentProduct, isCurrentProduct)
                .in(PromotionPolicyProductEntity :: getPromotionPolicyId, promotionPolicyIds));
        Map<String, Map<String, PromotionPolicyProductEntity>> result = Maps.newHashMap();
        //按政策id收集列表
        Map<String, List<PromotionPolicyProductEntity>> tempData = entities.stream()
                .collect(Collectors.groupingBy(PromotionPolicyProductEntity :: getPromotionPolicyId));
        tempData.forEach((promotionPolicyId, promotionPolicyProductEntities) -> {
            result.put(promotionPolicyId, promotionPolicyProductEntities.stream()
                    .collect(Collectors.toMap(PromotionPolicyProductEntity :: getProductCode
                            , v -> v, (p, p2) -> p2)));
        });
        //查询的本品
        if(CommonConstant.GLOBAL.YesOrNo.Y.getItemCode().equals(isCurrentProduct)){
            loadConfigInfoContext.setCurrentProductY(result);
            Map<String, Map<String, PromotionPolicyProductEntity>> resultAsCurrentProductN = this.resolveCurrentN(tempData);
            loadConfigInfoContext.addCurrentProductCodesN(entities.stream().filter(v -> {
                //过滤掉不是一一对应的本品配置
                return StringUtils.isNotBlank(v.getProductCodeGift());
            }).map(PromotionPolicyProductEntity :: getProductCodeGift).collect(Collectors.toSet()));
            loadConfigInfoContext.addCurrentProductN(resultAsCurrentProductN);
        }
        //查询的赠品
        if(CommonConstant.GLOBAL.YesOrNo.N.getItemCode().equals(isCurrentProduct)){
            loadConfigInfoContext.addCurrentProductCodesN(entities.stream().map(PromotionPolicyProductEntity :: getProductCode).collect(Collectors.toSet()));
            loadConfigInfoContext.addCurrentProductN(result);
        }
    }

    /**
     * 根据政策id列表查询商品
     * @param promotionIds
     * @param isCurrent
     * @return
     */
    @Override
    public Map<String, List<PromotionPolicyProductEntity>> findProductsByPromotionIds(ArrayList<String> promotionIds, String isCurrent) {
        if(CollectionUtil.listEmpty(promotionIds)) {
            return Maps.newHashMap();
        }
        QueryWrapper wrapper = Wrappers.<PromotionPolicyProductEntity>query()
                .eq(StringUtils.isNotBlank(isCurrent), "current_product", isCurrent)
                .in("promotion_policy_id", promotionIds);
        List<PromotionPolicyProductEntity> productEntities = this.promotionPolicyProductMapper.selectList(wrapper);
        if(CollectionUtil.listEmpty(productEntities)) {
            return promotionIds.stream().collect(Collectors.toMap(a -> a, a -> Lists.newArrayList()));
        }
        Map<String, List<PromotionPolicyProductEntity>> result = productEntities.stream().collect(Collectors.groupingBy(PromotionPolicyProductEntity::getPromotionPolicyId));
        promotionIds.forEach(id -> {
            if(CollectionUtil.listEmpty(result.get(id))) {
                result.put(id, Lists.newArrayList());
            }
        });
        return result;
    }

    /**
     * 解析一一对应的本品上的赠品配置并组装出来
     * @param tempData
     * @return
     */
    private Map<String, Map<String, PromotionPolicyProductEntity>> resolveCurrentN(Map<String, List<PromotionPolicyProductEntity>> tempData){
        Map<String, Map<String, PromotionPolicyProductEntity>> resultAsCurrentProductN = Maps.newHashMap();
        //把是一一对应的本品上的赠品配置解析并组装出来
        tempData.forEach((promotionPolicyId, promotionPolicyProductEntities) -> {
            resultAsCurrentProductN.put(promotionPolicyId, promotionPolicyProductEntities.stream().filter(v -> {
                //过滤掉不是一一对应的本品配置
                return StringUtils.isNotBlank(v.getProductCodeGift());
            }).collect(Collectors.toMap(PromotionPolicyProductEntity :: getProductCodeGift, v -> {
                //用一一对应的本品拷贝一份出来，组装一份赠品配置
                    PromotionPolicyProductEntity gift = CrmBeanUtil.copy(v, PromotionPolicyProductEntity.class);
                    gift.setProductCode(gift.getProductCodeGift());
                    gift.setProductName(gift.getProductNameGift());
                    return gift;
                }, (p, p2) -> {
                //用一一对应的本品拷贝一份出来，组装一份赠品配置
                    PromotionPolicyProductEntity gift = CrmBeanUtil.copy(p2, PromotionPolicyProductEntity.class);
                    gift.setProductCode(gift.getProductCodeGift());
                    gift.setProductName(gift.getProductNameGift());
                    return gift;
            })));
        });

        return resultAsCurrentProductN;

    }

}
