package com.biz.crm.promotion.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyEditReqVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyEditVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyScope;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyScopeEditVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyScopeGroup;
import com.biz.crm.nebular.mdm.customer.CustomerCodeConditionReqVo;
import com.biz.crm.promotion.entity.PromotionPolicyScopeEntity;
import com.biz.crm.promotion.enums.AccountTypeDynamicEnum;
import com.biz.crm.eunm.dms.ScopeTypeDynamicEnum;
import com.biz.crm.promotion.mapper.PromotionPolicyScopeMapper;
import com.biz.crm.promotion.service.PromotionPolicyScopeService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.ComConstant;
import com.biz.crm.util.CommonConstant;
import com.biz.crm.util.CommonFieldUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.ValidateUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;


/**
 *  @author: luoqi
 *  @Date: 2020-10-15 16:50
 *  @version: V1.0
 *  @Description:
 */
@Transactional
@ConditionalOnMissingBean(name = "promotionPolicyScopeServiceExpandImpl")
@Service("promotionPolicyScopeService")
public class PromotionPolicyScopeServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<PromotionPolicyScopeMapper, PromotionPolicyScopeEntity> implements PromotionPolicyScopeService {

    @Resource
    private PromotionPolicyScopeMapper promotionPolicyScopeMapper;
    @Resource
    private MdmCustomerMsgFeign mdmCustomerMsgFeign;

    /**
     * @param editVo
     * @author: luoqi
     * @Date: 2020-10-19 16:28
     * @version: V1.0
     * @Description:
     */
    @Override
    public void refreshScope(PromotionPolicyEditReqVo editVo) {
        //删除旧的促销范围
        if(StringUtils.isNotBlank(editVo.getId())){
            this.doDelByPromotionPolicyIdOrCode(Lists.newArrayList(editVo.getId()), null);
        }
        //校验范围类型
        if(CommonConstant.DMS.PROMOTION_SCOPE_HOST_TYPE.TERMINAL.getItemCode().equals(editVo.getScopeType())) {
            ValidateUtils.isTrue(editVo.getPromotionPolicyScope().getScopesAsCust() == null
                            && editVo.getPromotionPolicyScope().getScopesAsOrg() == null
                    , "当范围类型为终端时，不能传入客户或者客户组织");
        } else {
            ValidateUtils.isTrue(editVo.getPromotionPolicyScope().getScopesAsTerminal() == null
                            && editVo.getPromotionPolicyScope().getScopesAsTerminalOrg() == null
                    , "当范围类型为经销商时，不能传入终端或者终端组织");
        }
        List<PromotionPolicyScopeEditVo> tempEditVos = editVo.takeAllScopes()
                , editVos = Lists.newArrayList();
        if(CollectionUtils.isEmpty(tempEditVos)){
            return;
        }
        Set<String> keys = Sets.newHashSet();
        for(PromotionPolicyScopeEditVo temp : tempEditVos){
            String key = temp.getPromotionPolicyId() + temp.getScopeCode() + temp.getScopeType() + temp.getContainable();
            if(keys.contains(key)){
                continue;
            }
            temp.setId(null);
            temp.setPromotionPolicyCode(editVo.getPromotionPolicyCode());
            temp.setPromotionPolicyId(editVo.getId());
            temp.setPromotionPolicyName(editVo.getPromotionPolicyName());
            editVos.add(temp);
            keys.add(key);
        }
        this.saveBatch(CrmBeanUtil.copyList(editVos, PromotionPolicyScopeEntity.class));
    }

    /**
     * 加载政策编辑页面促销范围
     *
     * @param editVo
     * @author: luoqi
     * @Date: 2020-10-20 21:16
     * @version: V1.0
     * @Description:
     */
    @Override
    public void loadListForEditPromotionPolicy(PromotionPolicyEditVo editVo) {

        List<PromotionPolicyScopeEntity>
//                channelY = null,//渠道包含
//                channelN = null,//渠道非包含
                custY = null,//客户包含
                custN = null,//客户非包含
                orgY = null,//组织包含
                orgN = null,//组织非包含
                terminalY = null,//终端包含
                terminalN = null,//终端非包含
                terminalOrgY = null,//终端组织包含
                terminalOrgN = null;//终端组织非包含

        if(StringUtils.isNotBlank(editVo.getId())){
            QueryWrapper<PromotionPolicyScopeEntity> wrapper = Wrappers.query();
            wrapper.in("promotion_policy_id", editVo.getId());
            Map<String, List<PromotionPolicyScopeEntity>> groupByScopeType = promotionPolicyScopeMapper.selectList(wrapper).stream()
                    .collect(Collectors.groupingBy(v -> {
                        return v.getScopeType() + v.getContainable();
                    }));
//            //渠道包含
//            channelY = groupByScopeType.get(
//                    CommonConstant.DMS.PromotionPolicyScopeType.CHANNEL.getItemCode() + CommonConstant.GLOBAL.YesOrNo.Y.getItemCode());
//            //渠道非包含
//            channelN = groupByScopeType.get(
//                    CommonConstant.DMS.PromotionPolicyScopeType.CHANNEL.getItemCode() + CommonConstant.GLOBAL.YesOrNo.N.getItemCode());
            //客户包含
            custY = groupByScopeType.get(
                    CommonConstant.DMS.PromotionPolicyScopeType.CUST.getItemCode() + CommonConstant.GLOBAL.YesOrNo.Y.getItemCode());
            //客户非包含
            custN = groupByScopeType.get(
                    CommonConstant.DMS.PromotionPolicyScopeType.CUST.getItemCode() + CommonConstant.GLOBAL.YesOrNo.N.getItemCode());
            //组织包含
            orgY = groupByScopeType.get(
                    CommonConstant.DMS.PromotionPolicyScopeType.ORG.getItemCode() + CommonConstant.GLOBAL.YesOrNo.Y.getItemCode());
            //组织非包含
            orgN = groupByScopeType.get(
                    CommonConstant.DMS.PromotionPolicyScopeType.ORG.getItemCode() + CommonConstant.GLOBAL.YesOrNo.N.getItemCode());
            //终端包含
            terminalY = groupByScopeType.get(
                    CommonConstant.DMS.PromotionPolicyScopeType.TERMINAL.getItemCode() + CommonConstant.GLOBAL.YesOrNo.Y.getItemCode());
            //终端非包含
            terminalN = groupByScopeType.get(
                    CommonConstant.DMS.PromotionPolicyScopeType.TERMINAL.getItemCode() + CommonConstant.GLOBAL.YesOrNo.N.getItemCode());
            //终端组织包含
            terminalOrgY = groupByScopeType.get(
                    CommonConstant.DMS.PromotionPolicyScopeType.TERMINAL_ORG.getItemCode() + CommonConstant.GLOBAL.YesOrNo.Y.getItemCode());
            //终端组织非包含
            terminalOrgN = groupByScopeType.get(
                    CommonConstant.DMS.PromotionPolicyScopeType.TERMINAL_ORG.getItemCode() + CommonConstant.GLOBAL.YesOrNo.N.getItemCode());

        }

        PromotionPolicyScopeGroup scopesAsOrg = new PromotionPolicyScopeGroup();
        scopesAsOrg.setContainN(CrmBeanUtil.copyList(orgN, PromotionPolicyScopeEditVo.class));
        scopesAsOrg.setContainY(CrmBeanUtil.copyList(orgY, PromotionPolicyScopeEditVo.class));
//        PromotionPolicyScopeGroup scopesAsChannel = new PromotionPolicyScopeGroup();
//        scopesAsChannel.setContainN(CrmBeanUtil.copyList(channelN, PromotionPolicyScopeEditVo.class));
//        scopesAsChannel.setContainY(CrmBeanUtil.copyList(channelY, PromotionPolicyScopeEditVo.class));
        PromotionPolicyScopeGroup scopesAsCust = new PromotionPolicyScopeGroup();
        scopesAsCust.setContainN(CrmBeanUtil.copyList(custN, PromotionPolicyScopeEditVo.class));
        scopesAsCust.setContainY(CrmBeanUtil.copyList(custY, PromotionPolicyScopeEditVo.class));

        PromotionPolicyScopeGroup scopesAsTerminal = new PromotionPolicyScopeGroup();
        scopesAsTerminal.setContainN(CrmBeanUtil.copyList(terminalN, PromotionPolicyScopeEditVo.class));
        scopesAsTerminal.setContainY(CrmBeanUtil.copyList(terminalY, PromotionPolicyScopeEditVo.class));

        PromotionPolicyScopeGroup scopesAsTerminalOrg = new PromotionPolicyScopeGroup();
        scopesAsTerminalOrg.setContainN(CrmBeanUtil.copyList(terminalOrgN, PromotionPolicyScopeEditVo.class));
        scopesAsTerminalOrg.setContainY(CrmBeanUtil.copyList(terminalOrgY, PromotionPolicyScopeEditVo.class));

        PromotionPolicyScope promotionPolicyScope = new PromotionPolicyScope();
//        promotionPolicyScope.setScopesAsChannel(scopesAsChannel);
        promotionPolicyScope.setScopesAsCust(scopesAsCust);
        promotionPolicyScope.setScopesAsOrg(scopesAsOrg);
        promotionPolicyScope.setScopesAsTerminal(scopesAsTerminal);
        promotionPolicyScope.setScopesAsTerminalOrg(scopesAsTerminalOrg);
        editVo.setPromotionPolicyScope(promotionPolicyScope);
    }

    /**
     * 按政策id或政策code 批量删除
     *
     * @param promotionPolicyId
     * @param promotionPolicyCode
     * @author: luoqi
     * @Date: 2020-10-20 16:01
     * @version: V1.0
     * @Description:
     */
    @Override
    public void delByPromotionPolicyIdOrCode(List<String> promotionPolicyId, List<String> promotionPolicyCode) {
        this.doDelByPromotionPolicyIdOrCode(promotionPolicyId, promotionPolicyCode);
    }

    /**
     * 查询范围对应的政策id列表
     *
     * @param custCode
     * @param orgCodes
     * @return
     */
    @Override
    public Set<String> selectPromotionPolicyIdByScopeCode(String custCode, Set<String> orgCodes) {
        if(null == orgCodes){
            orgCodes = Sets.newHashSet();
        }
        //匹配上的政策id
        Set<String> matchedPromotionPolicyId = Sets.newHashSet();
        if(StringUtils.isBlank(custCode) && CollectionUtils.isEmpty(orgCodes)){
            return matchedPromotionPolicyId;
        }
//        String containable = null == containableYesOrNo ? CommonConstant.GLOBAL.YesOrNo.Y.getItemCode() : containableYesOrNo.getItemCode();
        //查询所有政策范围配置，并以政策id分组
        Map<String, List<PromotionPolicyScopeEntity>> promotionPolicyIdMapScope = this.promotionPolicyScopeMapper.selectList(Wrappers.lambdaQuery(PromotionPolicyScopeEntity.class))
                .stream().collect(Collectors.groupingBy(PromotionPolicyScopeEntity :: getPromotionPolicyId));
        //遍历政策范围配置，计算能够匹配上的政策
        for(Map.Entry<String, List<PromotionPolicyScopeEntity>> entry : promotionPolicyIdMapScope.entrySet()){
            List<PromotionPolicyScopeEntity> scopeEntities = entry.getValue();
            //以范围类型分组
            Map<String, List<PromotionPolicyScopeEntity>> scopeTypeMapScope = scopeEntities.stream().collect(Collectors.groupingBy(PromotionPolicyScopeEntity :: getScopeType));
            //客户类型的范围
            List<PromotionPolicyScopeEntity> scopeAsCust = scopeTypeMapScope.get(CommonConstant.DMS.PromotionPolicyScopeType.CUST.getItemCode());
            //组织类型的范围
            List<PromotionPolicyScopeEntity> scopeAsOrg = scopeTypeMapScope.get(CommonConstant.DMS.PromotionPolicyScopeType.ORG.getItemCode());
            //用客户匹配客户类型的【包含范围】
            boolean matchedAsCustContainableY = this.doMatchScopeContainableY(scopeAsCust, Sets.newHashSet(custCode));
            //用客户匹配客户类型的【非包含范围】
            boolean matchedAsCustContainableN = this.doMatchScopeContainableN(scopeAsCust, Sets.newHashSet(custCode));
            //用组织匹配组织类型的【包含范围】
            boolean matchedAsOrgContainableY = this.doMatchScopeContainableY(scopeAsOrg, orgCodes);
            //用组织匹配组织类型的【非包含范围】
            boolean matchedAsOrgContainableN = this.doMatchScopeContainableN(scopeAsOrg, orgCodes);

            if((matchedAsCustContainableY || matchedAsOrgContainableY) //匹配包含时，只要组织或客户有一个能匹配，那么都匹配成功
                    && (!matchedAsCustContainableN && !matchedAsOrgContainableN)){//匹配非包含时，只要组织或客户有一个能匹配，那么都匹配失败
                matchedPromotionPolicyId.add(entry.getKey());
            }
        }
        return matchedPromotionPolicyId;
    }

    /**
     * 查询范围对应的政策id列表（终端）
     * @param terminalCode 终端编码
     * @param orgCodes
     * @return
     */
    @Override
    public Set<String> selectPromotionPolicyIdByTerminal(String terminalCode, Set<String> orgCodes) {
        //匹配上的政策id
        Set<String> matchedPromotionPolicyId = Sets.newHashSet();
        if(StringUtils.isBlank(terminalCode)){
            return matchedPromotionPolicyId;
        }
//        String containable = null == containableYesOrNo ? CommonConstant.GLOBAL.YesOrNo.Y.getItemCode() : containableYesOrNo.getItemCode();
        //查询所有政策范围配置，并以政策id分组
        Map<String, List<PromotionPolicyScopeEntity>> promotionPolicyIdMapScope = this.promotionPolicyScopeMapper.selectList(Wrappers.lambdaQuery(PromotionPolicyScopeEntity.class))
                .stream().collect(Collectors.groupingBy(PromotionPolicyScopeEntity :: getPromotionPolicyId));
        //遍历政策范围配置，计算能够匹配上的政策
        for(Map.Entry<String, List<PromotionPolicyScopeEntity>> entry : promotionPolicyIdMapScope.entrySet()){
            List<PromotionPolicyScopeEntity> scopeEntities = entry.getValue();
            //以范围类型分组
            Map<String, List<PromotionPolicyScopeEntity>> scopeTypeMapScope = scopeEntities.stream().collect(Collectors.groupingBy(PromotionPolicyScopeEntity :: getScopeType));
            //终端类型的范围
            List<PromotionPolicyScopeEntity> scopeTerminal = scopeTypeMapScope.get(CommonConstant.DMS.PromotionPolicyScopeType.TERMINAL.getItemCode());
            //终端组织类型的范围
            List<PromotionPolicyScopeEntity> scopeTerminalOrg = scopeTypeMapScope.get(CommonConstant.DMS.PromotionPolicyScopeType.TERMINAL_ORG.getItemCode());
            //终端【包含范围】
            boolean matchedAsCustContainableY = this.doMatchScopeContainableY(scopeTerminal, Sets.newHashSet(terminalCode));
            //终端【非包含范围】
            boolean matchedAsCustContainableN = this.doMatchScopeContainableN(scopeTerminal, Sets.newHashSet(terminalCode));
            //终端组织【包含范围】
            boolean matchedAsTerminalContainableY = this.doMatchScopeContainableY(scopeTerminalOrg, Sets.newHashSet(orgCodes));
            //终端组织【非包含范围】
            boolean matchedAsTerminalContainableN = this.doMatchScopeContainableY(scopeTerminalOrg, Sets.newHashSet(orgCodes));

            if(matchedAsCustContainableY//匹配包含时，只要组织或客户有一个能匹配，那么都匹配成功
                    && !matchedAsCustContainableN//匹配非包含时，只要组织或客户有一个能匹配，那么都匹配失败
                    || matchedAsTerminalContainableY
                    && !matchedAsTerminalContainableN){
                matchedPromotionPolicyId.add(entry.getKey());
            }
        }
        return matchedPromotionPolicyId;
    }

    /**
     * 匹配包含范围
     * @param scope
     * @param codes
     * @return
     */
    private boolean doMatchScopeContainableY(List<PromotionPolicyScopeEntity> scope, Set<String> codes){
        if(CollectionUtils.isEmpty(scope)){
            return false;
        }
        //以是否包含分组
        Map<String, List<PromotionPolicyScopeEntity>> containableMapScope = scope.stream().collect(Collectors.groupingBy(PromotionPolicyScopeEntity :: getContainable));
        //包含配置
        List<PromotionPolicyScopeEntity> scopeAsContainableY = containableMapScope.get(CommonConstant.GLOBAL.YesOrNo.Y.getItemCode());
        boolean isMatch = false;
        if(null != scopeAsContainableY){
            //存在于包含配置中，则匹配成功
            for(PromotionPolicyScopeEntity scopeEntity : scopeAsContainableY){
                if(codes.contains(scopeEntity.getScopeCode())){
                    isMatch = true;
                }
            }
        }
        return isMatch;
    }
    /**
     * 匹配非包含范围
     * @param scope
     * @param codes
     * @return
     */
    private boolean doMatchScopeContainableN(List<PromotionPolicyScopeEntity> scope, Set<String> codes){
        if(CollectionUtils.isEmpty(scope)){
            return false;
        }
        //以是否包含分组
        Map<String, List<PromotionPolicyScopeEntity>> containableMapScope = scope.stream().collect(Collectors.groupingBy(PromotionPolicyScopeEntity :: getContainable));
        //非包含配置
        List<PromotionPolicyScopeEntity> scopeAsContainableN = containableMapScope.get(CommonConstant.GLOBAL.YesOrNo.N.getItemCode());
        boolean isMatch = false;
        if(null != scopeAsContainableN){
            //存在于非包含配置中，则匹配失败
            for(PromotionPolicyScopeEntity scopeEntity : scopeAsContainableN){
                if(codes.contains(scopeEntity.getScopeCode())){
                    isMatch = true;
                }
            }
        }
        return isMatch;
    }
    /**
     * 计算给定政策下相关的客户编码
     *
     * @param promotionPolicyIds
     * @return
     */
    @Override
    public List<String> countCustCodesByPromotionPolicyId(Set<String> promotionPolicyIds) {
        if(CollectionUtils.isEmpty(promotionPolicyIds)){
            return Lists.newArrayList();
        }
        Set<String> custCodes = Sets.newHashSet();
        List<String> custCodesAsCust = this.promotionPolicyScopeMapper.selectCustCodesByPromotionPolicyId(Lists.newArrayList(promotionPolicyIds));
        custCodes.addAll(custCodesAsCust);
        List<String> channelCodes = this.promotionPolicyScopeMapper.selectChannelCodesByPromotionPolicyId(Lists.newArrayList(promotionPolicyIds));
        List<String> orgCodes = this.promotionPolicyScopeMapper.selectOrgCodesByPromotionPolicyId(Lists.newArrayList(promotionPolicyIds));
        if(!CollectionUtils.isEmpty(orgCodes)){
            CustomerCodeConditionReqVo reqVo = new CustomerCodeConditionReqVo();
            reqVo.setOrgCodeList(Lists.newArrayList(Sets.newHashSet(orgCodes)));
            Result<List<String>> custResult = mdmCustomerMsgFeign.findCustomerCodeConditionList(reqVo);
            List<String> custCodesAsOrg = ApiResultUtil.objResult(custResult, true);
            custCodes.addAll(custCodesAsOrg);
        }
        if(!CollectionUtils.isEmpty(channelCodes)){
            CustomerCodeConditionReqVo reqVo = new CustomerCodeConditionReqVo();
            reqVo.setChannelList(Lists.newArrayList(Sets.newHashSet(channelCodes)));
            Result<List<String>> custResult = mdmCustomerMsgFeign.findCustomerCodeConditionList(reqVo);
            List<String> custCodesAsChannel = ApiResultUtil.objResult(custResult, true);
            custCodes.addAll(custCodesAsChannel);
        }
        return Lists.newArrayList(custCodes);
    }

    /**
     * @param accountCodes 账户编码，可能是客户编码、终端编码等
     * @param orgCodes     组织编码，可能是客户组织编码、终端组织编码等
     * @param channelCodes 渠道编码，可能是客户渠道编码、终端渠道编码等
     * @param accountType  账户类型，{@link ScopeTypeDynamicEnum} && {@link AccountTypeDynamicEnum}
     * @param orgType      组织类型，{@link ScopeTypeDynamicEnum} && {@link AccountTypeDynamicEnum}
     * @param channelType  渠道类型，{@link ScopeTypeDynamicEnum} && {@link AccountTypeDynamicEnum}
     * @return
     */
    @Override
    public List<String> findPromotionCodesByAccounts(List<String> accountCodes, List<String> orgCodes, List<String> channelCodes,
                                                     String accountType, String orgType, String channelType) {
        LambdaQueryWrapper<PromotionPolicyScopeEntity> wrapper = Wrappers.lambdaQuery();
        wrapper.in(CollectionUtil.listNotEmpty(accountCodes), PromotionPolicyScopeEntity::getScopeCode, accountCodes)
                .and(w -> w.eq(StringUtils.isNotBlank(accountType), PromotionPolicyScopeEntity::getScopeType, accountType));
        wrapper.in(CollectionUtil.listNotEmpty(orgCodes), PromotionPolicyScopeEntity::getScopeCode, orgCodes);
        return null;
    }

    /**
     * 根据账户查询可用促销政策（可变参数）
     * 功能与该方法相同：{@link PromotionPolicyScopeService#findPromotionCodesByAccounts(List, List, List, String, String, String)}
     * @param unitCodeLists   对象编码列表数组
     * @param unitTypes   对象编码类型数组
     * @return
     */
    @Override
    public List<String> findPromotionCodesByAccounts(List<String>[] unitCodeLists, String... unitTypes) {
        if(unitCodeLists == null || unitCodeLists.length == 0
        || unitTypes == null || unitTypes.length == 0) {
            return Lists.newArrayList();
        }
        ValidateUtils.isTrue(unitCodeLists.length == unitTypes.length, "根据账户查询可用促销政策时，传入的对象编码列表数组和对象编码类型数组两个参数个数应该相同");
        //查询包含的列表
        LambdaQueryWrapper<PromotionPolicyScopeEntity> containWrapper = Wrappers.lambdaQuery();
        for(int i = 0; i < unitCodeLists.length; i++) {
            List<String> unitCodes = unitCodeLists[i];
            String unitType = unitTypes[i];
            if(CollectionUtil.listEmpty(unitCodes) || StringUtils.isBlank(unitType)) {
                continue;
            }
            containWrapper.or(i > 0);
            containWrapper.in(PromotionPolicyScopeEntity::getScopeCode, unitCodes);
            containWrapper.and(w -> w.eq(PromotionPolicyScopeEntity::getScopeType, unitType));
            containWrapper.and(w -> w.eq(PromotionPolicyScopeEntity::getContainable, ComConstant.GLOBAL.YesOrNo.Y.getItemCode()));
        }
        //查询非包含的列表
        LambdaQueryWrapper<PromotionPolicyScopeEntity> unContainWrapper = Wrappers.lambdaQuery();
        for(int i = 0; i < unitCodeLists.length; i++) {
            List<String> unitCodes = unitCodeLists[i];
            String unitType = unitTypes[i];
            if(CollectionUtil.listEmpty(unitCodes) || StringUtils.isBlank(unitType)) {
                continue;
            }
            containWrapper.or(i > 0);
            unContainWrapper.in(PromotionPolicyScopeEntity::getScopeCode, unitCodes)
                    .and(w -> w.eq(PromotionPolicyScopeEntity::getScopeType, unitType))
                    .and(w -> w.eq(PromotionPolicyScopeEntity::getContainable, ComConstant.GLOBAL.YesOrNo.N.getItemCode()));
        }
        List<PromotionPolicyScopeEntity> containEntities = this.promotionPolicyScopeMapper.selectList(containWrapper);
        List<PromotionPolicyScopeEntity> unContainEntities = this.promotionPolicyScopeMapper.selectList(unContainWrapper);
        List<String> promotionCodes = CommonFieldUtil.difference(containEntities, unContainEntities, "promotionPolicyCode");
        if(!CollectionUtil.collectionNotEmpty(promotionCodes)) {
            return Lists.newArrayList();
        }

        return promotionCodes;
    }


    /**
     * 删除政策下的促销范围
     *  @author: luoqi
     *  @Date: 2020-10-20 11:22
     *  @version: V1.0
     *  @Description:
     */
    private void doDelByPromotionPolicyIdOrCode(List<String> promotionPolicyId, List<String> promotionPolicyCode){
        QueryWrapper<PromotionPolicyScopeEntity> wrapper = Wrappers.query();
        if(!CollectionUtils.isEmpty(promotionPolicyId)){
            wrapper.in("promotion_policy_id", promotionPolicyId);
        }else if(!CollectionUtils.isEmpty(promotionPolicyCode)){
            wrapper.in("promotion_policy_code", promotionPolicyCode);
        }else{
            return;
        }
        promotionPolicyScopeMapper.delete(wrapper);
    }
}
