package com.biz.crm.promotion.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.promotion.entity.PromotionPolicyTemplateRuleEntity;
import com.biz.crm.promotion.mapper.PromotionPolicyTemplateRuleMapper;
import com.biz.crm.promotion.service.PromotionPolicyTemplateRuleService;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.List;


/**
 *  @author: luoqi
 *  @Date: 2020-10-15 16:50
 *  @version: V1.0
 *  @Description:
 */
@ConditionalOnMissingBean(name = "promotionPolicyTemplateRuleServiceExpandImpl")
@Transactional
@Service("promotionPolicyTemplateRuleService")
public class PromotionPolicyTemplateRuleServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<PromotionPolicyTemplateRuleMapper, PromotionPolicyTemplateRuleEntity> implements PromotionPolicyTemplateRuleService {

    @Resource
    private PromotionPolicyTemplateRuleMapper promotionPolicyTemplateRuleMapper;

    @Transactional
    @Override
    public void saveList(List<PromotionPolicyTemplateRuleEntity> list) {
        if(CollectionUtils.isEmpty(list)){
            return;
        }
        this.saveBatch(list);
    }

    @Override
    public List<PromotionPolicyTemplateRuleEntity> getEntitysByTemplateId(String templateId) {
        if(StringUtils.isBlank(templateId)){
            return Lists.newArrayList();
        }
        QueryWrapper<PromotionPolicyTemplateRuleEntity> wrapper = new QueryWrapper<>();
        wrapper.in("promotion_policy_template_id", templateId);
        return promotionPolicyTemplateRuleMapper.selectList(wrapper);

    }
}
