package com.biz.crm.promotion.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.config.SpringApplicationContextUtil;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyTemplateEditVo;
import com.biz.crm.nebular.dms.promotion.PromotionRuleEditVo;
import com.biz.crm.nebular.dms.promotion.PromotionRuleSelectionVo;
import com.biz.crm.nebular.dms.promotion.PromotionRuleVo;
import com.biz.crm.promotion.entity.PromotionPolicyRuleEntity;
import com.biz.crm.promotion.entity.PromotionPolicyTemplateRuleEntity;
import com.biz.crm.promotion.entity.PromotionRuleEntity;
import com.biz.crm.eunm.dms.RuleTypeDynamicEnum;
import com.biz.crm.promotion.mapper.PromotionPolicyRuleMapper;
import com.biz.crm.promotion.mapper.PromotionPolicyTemplateRuleMapper;
import com.biz.crm.promotion.mapper.PromotionRuleMapper;
import com.biz.crm.promotion.service.PromotionPolicyTemplateRuleService;
import com.biz.crm.promotion.service.PromotionRuleService;
import com.biz.crm.promotion.service.component.function.RuleFunction;
import com.biz.crm.promotion.service.component.function.param.TestRuleParam;
import com.biz.crm.promotion.util.PromotionUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.ValidateUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;


/**
 *  @author: luoqi
 *  @Date: 2020-10-15 16:50
 *  @version: V1.0
 *  @Description:
 */
@Transactional
@ConditionalOnMissingBean(name = "pomotionRuleServiceExpandImpl")
@Service("pomotionRuleService")
public class PromotionRuleServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<PromotionRuleMapper, PromotionRuleEntity> implements PromotionRuleService {

    @Resource
    private PromotionRuleMapper promotionRuleMapper;
    @Resource
    private PromotionPolicyTemplateRuleService promotionPolicyTemplateRuleService;
    @Resource
    private PromotionPolicyTemplateRuleMapper promotionPolicyTemplateRuleMapper;
    @Resource
    private PromotionPolicyRuleMapper promotionPolicyRuleMapper;

    /**
     * 1.删除和编辑规则 --------------
     * a) 规则关联了模板，可以编辑
     * b) 规则关联了模板，不可删除
     * c) 已关联政策，只能编辑函数体
     *  @author: luoqi
     *  @Date: 2020-10-21 17:12
     *  @version: V1.0
     *  @Description:
     */
    @Override
    public String addOrUpdate(PromotionRuleEditVo vo) {
        this.checkParams(vo);
        if((RuleTypeDynamicEnum.CONDITION.getCode().equals(vo.getRuleType())
                || RuleTypeDynamicEnum.CALCULATE.getCode().equals(vo.getRuleType()))
        && vo.getTestParam()!=null) {
            PromotionUtil.validateLadder(vo.getTestParam().getControlRow());
        }
        PromotionRuleEntity entity;
        if(StringUtils.isBlank(vo.getId())){
            QueryWrapper<PromotionRuleEntity> wrapper = new QueryWrapper<>();
            wrapper.eq("rule_code", vo.getRuleCode());
            if(this.promotionRuleMapper.selectCount(wrapper) > 0){
                throw new BusinessException("已存在的规则编码[" + vo.getRuleCode() + "]。");
            }
            entity = CrmBeanUtil.copy(vo, PromotionRuleEntity.class);
            entity.setTestParam(JsonPropertyUtil.toJsonString(vo.getTestParam()));
            this.promotionRuleMapper.insert(entity);
            vo.setId(entity.getId());
        }else{
            if(null == this.promotionRuleMapper.selectById(vo.getId())){
                throw new BusinessException("规则数据不存在,ID=[" + vo.getId() + "]");
            }

            entity = new PromotionRuleEntity();
            entity.setLevelNo(vo.getLevelNo());
            entity.setFuncBody(vo.getFuncBody());
            entity.setTestParam(JsonPropertyUtil.toJsonString(vo.getTestParam()));
            QueryWrapper<PromotionPolicyRuleEntity> wrapper = new QueryWrapper<>();
            wrapper.eq("promotion_rule_id", vo.getId());
            // c) 已关联政策，只能编辑函数体 不能编辑名称
            if(promotionPolicyRuleMapper.selectCount(wrapper) == 0){
                entity.setRuleName(vo.getRuleName());
            }
            entity.setId(vo.getId());
            entity.setRemarks(vo.getRemarks());
            this.promotionRuleMapper.updateById(entity);
        }
        this.doTestFunc(this.promotionRuleMapper.selectById(vo.getId()));
        PromotionUtil.setRuleOneCache(entity.getRuleCode(), CrmBeanUtil.copy(entity, PromotionRuleEditVo.class));
        return vo.getId();
    }



    /**
     * 1.删除和编辑规则 --------------
     * a) 规则关联了模板，可以编辑
     * b) 规则关联了模板，不可删除
     * c) 已关联政策，只能编辑函数体
     *  @author: luoqi
     *  @Date: 2020-10-21 17:12
     *  @version: V1.0
     *  @Description:
     */
    @Override
    public void del(String id) {
        if(StringUtils.isNotBlank(id)){
            QueryWrapper<PromotionPolicyTemplateRuleEntity> wrapper = new QueryWrapper<>();
            wrapper.eq("promotion_rule_id", id);
//            if(promotionPolicyTemplateRuleMapper.selectCount(wrapper) > 0){
//                throw new BusinessException("操作失败，该规则已关联模板数据。");
//            }
            this.promotionRuleMapper.deleteById(id);
        }
    }

    @Override
    public List<PromotionRuleVo> getList(PromotionRuleVo vo) {
        List<PromotionRuleEntity> list = this.getListEntity(vo);
        return CrmBeanUtil.copyList(list, PromotionRuleVo.class);
    }

    @Override
    public PromotionRuleEditVo loadEditVoById(String id) {
        ValidateUtils.validate(id,"请指定规则ID");
        PromotionRuleEntity entity = promotionRuleMapper.selectById(id);
        ValidateUtils.validate(entity,"未加载到规则数据");
        PromotionRuleEditVo vo = CrmBeanUtil.copy(entity, PromotionRuleEditVo.class);
        vo.setTestParam(JsonPropertyUtil.toObject(entity.getTestParam(), PromotionRuleEditVo.TestParam.class));
        return vo;
    }

    public static void main(String[] args) {
        String json = "{\"bizParam\":{\"productOrderBuy\":[{\"productBuyNo\":\"20\",\"productBuyAmount\":\"1000\",\"unitConvertor\":\"10\"}]},\"controlRow\":{\"text\":\"本单中本品数量购买满\",\"controlKey\":\"control_key\",\"controlType\":\"countAmount\",\"controls\":[{\"key\":\"buyNo\",\"value\":\"10\",\"label\":\"\",\"labelPostfix\":\"\",\"description\":\"请输入本品数量\",\"controlType\":\"input\",\"selectOptions\":[]},{\"key\":\"buyUnit\",\"value\":\"baseUnit\",\"label\":\"\",\"labelPostfix\":\"\",\"description\":\"请选择单位\",\"controlType\":\"select\",\"selectOptions\":[{\"key\":\"baseUnit\",\"value\":\"基本单位\"},{\"key\":\"saleUnit\",\"value\":\"销售单位\"}]},{\"key\":\"giftNo\",\"value\":\"55\",\"label\":\"，减金额（元）\",\"labelPostfix\":\"\",\"description\":\"请输入减免金额\",\"controlType\":\"input\",\"selectOptions\":[]}]}}";
        PromotionRuleEditVo.TestParam rel = JsonPropertyUtil.toObject(json, PromotionRuleEditVo.TestParam.class);
    }

    private List<PromotionRuleEntity> getListEntity(PromotionRuleVo vo){
        QueryWrapper<PromotionRuleEntity> wrapper = new QueryWrapper<>();
        String getPromotionType = vo.getPromotionType();
        String getRuleType = vo.getRuleType();
        if(StringUtils.isNotBlank(getPromotionType)){
            wrapper.in("promotion_type"
                    , Lists.newArrayList(getPromotionType, PromotionRuleVo.PROMOTION_TYPE.def.name()));
        }
        if(StringUtils.isNotBlank(getRuleType)){
            wrapper.eq("rule_type", getRuleType);
        }
        List<PromotionRuleEntity> list = this.promotionRuleMapper.selectList(wrapper);
        return list;
    }

    /**
     * 加载模板规则数据
     *
     * @param templateEditVo
     * @author: luoqi
     * @Date: 2020-10-17 14:23
     * @version: V1.0
     * @Description:
     */
    @Override
    public PromotionPolicyTemplateEditVo loadTemplateRuleGroupByRuleType(PromotionPolicyTemplateEditVo templateEditVo, boolean allRule) {
        if(null == templateEditVo){
            return null;
        }
        Map<String, PromotionPolicyTemplateRuleEntity> templateRuleEntityMap;
        if(StringUtils.isNotBlank(templateEditVo.getId())){
            templateRuleEntityMap = this.promotionPolicyTemplateRuleService.getEntitysByTemplateId(templateEditVo.getId()).stream()
                    .collect(Collectors.toMap(PromotionPolicyTemplateRuleEntity :: getPromotionRuleId, v -> v, (t, t2) -> t2));
        }else{
            templateRuleEntityMap = Maps.newHashMap();
        }
        PromotionRuleVo vo = new PromotionRuleVo();
        vo.setPromotionType(templateEditVo.getPromotionType());
        List<PromotionRuleEntity> list = this.getListEntity(vo);
        //条件规则
        List<PromotionRuleSelectionVo> condition = Lists.newArrayList();
        //限量规则
        List<PromotionRuleSelectionVo> limited = Lists.newArrayList();
        //计算规则
        List<PromotionRuleSelectionVo> calculate = Lists.newArrayList();
        for(PromotionRuleEntity entity : list){
            boolean selected = templateRuleEntityMap.containsKey(entity.getId());
            if(!selected && !allRule){
                //模板没选中改规则，并且不加载全部工作。
                // 该判断用于两种业务场景 :
                // 1.查询模板编辑页面的数据时需要加载全部规则。
                // 2.在政策页面查询模板消息时只需加载当前模板选中的规则
                continue;
            }
            PromotionRuleSelectionVo tempVo = CrmBeanUtil.copy(entity, PromotionRuleSelectionVo.class);
            tempVo.setSelected(selected);
            if(PromotionRuleVo.RULE_TYPE.calculate.name().equals(tempVo.getRuleType())){
                calculate.add(tempVo);
            }else if(PromotionRuleVo.RULE_TYPE.condition.name().equals(tempVo.getRuleType())){
                condition.add(tempVo);
            }else if(PromotionRuleVo.RULE_TYPE.limited.name().equals(tempVo.getRuleType())){
                limited.add(tempVo);
            }
        }
        templateEditVo.setCalculate(calculate);
        templateEditVo.setLimited(limited);
        templateEditVo.setCondition(condition);
        return templateEditVo;
    }

    @Override
    public List<PromotionRuleEntity> getListByIds(Set<String> ids) {
        if(CollectionUtils.isEmpty(ids)){
            return Lists.newArrayList();
        }
        QueryWrapper<PromotionRuleEntity> wrapper = new QueryWrapper<>();
        wrapper.in("id", ids);
        List<PromotionRuleEntity> list = this.promotionRuleMapper.selectList(wrapper);
        return list;
    }

    /**
     * 根据规则编码查询
     * @param ruleCode
     * @return
     */
    @Override
    public PromotionRuleEditVo findByRuleCode(String ruleCode) {
        if(StringUtils.isBlank(ruleCode)) {
            return null;
        }
        List<PromotionRuleEntity> entities = this.promotionRuleMapper.selectList(
                Wrappers.<PromotionRuleEntity>lambdaQuery().eq(PromotionRuleEntity::getRuleCode, ruleCode));
        if(CollectionUtil.listEmpty(entities)) {
            return null;
        }
        return CrmBeanUtil.copy(entities.get(0), PromotionRuleEditVo.class);
    }


    /**
     * 测试脚本体
     *  @author: luoqi
     *  @Date: 2020-10-17 17:44
     *  @version: V1.0
     *  @Description:
     */
    @Override
    public Object testFunc(PromotionRuleEditVo vo){
        ValidateUtils.validate(vo.getFuncBody(),"函数实例名称不能为空!");
        //校验阶梯控件类型与格式是否匹配
        if(vo.getTestParam() != null && (RuleTypeDynamicEnum.CONDITION.getCode().equals(vo.getRuleType())
                || RuleTypeDynamicEnum.CALCULATE.getCode().equals(vo.getRuleType()))) {
            PromotionUtil.validateLadder(vo.getTestParam().getControlRow());
        }
        PromotionRuleEntity entity = CrmBeanUtil.copy(vo, PromotionRuleEntity.class);
        entity.setTestParam(JsonPropertyUtil.toJsonString(vo.getTestParam()));
        return this.doTestFunc(entity);
    }
    private Object doTestFunc(PromotionRuleEntity entity){
        if(StringUtils.isBlank(entity.getTestParam())){
            entity.setTestParam("{}");
        }
        RuleFunction ruleFunction;
        try {
            ruleFunction = SpringApplicationContextUtil
                    .getApplicationContext().getBean(entity.getFuncBody(), RuleFunction.class);
        }catch (BeansException e){
            throw new BusinessException("规则[" + entity.getFuncBody() + "]计算失败, 未查找到该规则的计算实例", e);
        }
        TestRuleParam ruleParam = new TestRuleParam();
        ruleParam.setRuleCode(entity.getRuleCode());
        PromotionRuleEditVo.TestParam testParam = JsonPropertyUtil.toObject(entity.getTestParam(), PromotionRuleEditVo.TestParam .class);
        ruleParam.setTestParam(testParam);
        return ruleFunction.test(ruleParam);
    }
    /**
     * 校验参数
     *  @author: luoqi
     *  @Date: 2020-10-15 17:42
     *  @version: V1.0
     *  @Description:
     */
    private void checkParams(PromotionRuleEditVo vo){
        ValidateUtils.validate(vo,"无效参数，请重试");
        ValidateUtils.validate(vo.getFuncBody(),"函数实例名称不能为空!");
        if(PromotionRuleVo.RULE_TYPE.limited.name().equals(vo.getRuleType())){
            vo.setPromotionType(PromotionRuleVo.PROMOTION_TYPE.def.name());
        }
        if(StringUtils.isBlank(vo.getId())){
            ValidateUtils.validate(vo.getPromotionType(),"促销类型不能为空!");
            ValidateUtils.validate(vo.getRuleCode(),"规则编码不能为空!");
            ValidateUtils.validate(vo.getRuleType(),"规则类型不能为空!");
            ValidateUtils.validate(vo.getRuleName(),"规则名称不能为空!");
        }
        PromotionRuleEditVo.TestParam testParam = vo.getTestParam();
        if(null == testParam){
            return;
        }
        PromotionRuleEditVo.ControlRow controlRow = testParam.getControlRow();
        if(null == controlRow){
            return;
        }
        if(null == controlRow.getControls()){
            controlRow.setControls(Lists.newArrayList());
            return;
        }
        controlRow.getControls().forEach(v -> {
            if(null == v.getSelectOptions()){
                v.setSelectOptions(Lists.newArrayList());
            }
        });
    }

}
