package com.biz.crm.promotion.service.npromotion;

import com.biz.crm.nebular.dms.npromotion.vo.PromotionProductVo;
import java.util.List;

/**
 * 促销商品逻辑处理类
 * @Author: chenrong
 * @Date: 2021/4/12 17:04
 */
public interface PromotionProductService {

  /**
   * 批量保存促销商品
   * 包含新增、修改、删除操作
   * @param productVos
   * @param promotionPolicyCode
   * @return
   */
  List<PromotionProductVo> saveBatch(List<PromotionProductVo> productVos, String promotionPolicyCode);

  /**
   * 根据促销政策编码查询促销商品列表
   * @param promotionPolicyCode
   * @return
   */
  List<PromotionProductVo> findByPromotionCode(String promotionPolicyCode);

  /**
   * 根据商品（本品）编码查询促销政策编码列表
   * @param productCode
   * @return
   */
  List<String> findPromotionCodesByProductCode(String productCode);
}
