package com.biz.crm.promotion.service.npromotion;

import com.biz.crm.nebular.dms.npromotion.vo.PromotionRuleVo;
import java.util.List;

/**
 * 促销规则逻辑处理类
 * @Author: chenrong
 * @Date: 2021/4/12 17:04
 */
public interface PromotionRuleService {

  /**
   * 批量保存促销规则，统一批次只能保存统一促销政策下的全量规则
   * 包含新增、编辑、删除
   * @param ruleVos
   * @param promotionPolicyCode
   * @return
   */
  List<PromotionRuleVo> saveBatch(List<PromotionRuleVo> ruleVos, String promotionPolicyCode);

  /**
   * 根据促销政策编码查询促销规则列表
   * @param promotionPolicyCode
   * @return
   */
  List<PromotionRuleVo> findByPromotionCode(String promotionPolicyCode);
}
