package com.biz.crm.promotion.service.npromotion.beans;

import com.biz.crm.nebular.dms.npromotion.bo.LadderParseBo;
import com.biz.crm.nebular.dms.promotion.PromotionRuleEditVo;
import com.biz.crm.nebular.dms.promotion.policy.resp.CalculateRuleResponse;
import com.biz.crm.promotion.service.component.function.RuleFunction;
import com.biz.crm.promotion.service.component.function.param.CalculateRuleParam;
import com.biz.crm.promotion.service.component.function.param.TestRuleParam;
import com.biz.crm.nebular.dms.npromotion.bo.CalculateParamBo;
import com.biz.crm.nebular.dms.npromotion.bo.CalculateResultBo;
import com.biz.crm.nebular.dms.npromotion.bo.ConditionParamBo;
import com.biz.crm.nebular.dms.npromotion.bo.ConditionResultBo;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionProductVo;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionSaleProductVo;
import com.biz.crm.promotion.util.PromotionUtil;
import com.biz.crm.util.CollectionUtil;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 计算处理抽象类
 * @Author: chenrong
 * @Date: 2021/4/21 15:15
 */
public abstract class AbstractCalculateComputer implements RuleFunction<CalculateRuleParam, CalculateRuleResponse> {

  //单个阶梯
  public static final int SINGLE = 1;
  //阶梯叠加
  public static final int LADDER = 2;
  //阶梯循环叠加
  public static final int LADDER_LOOP = 3;

  /**
   * 政策阶梯优惠上限，校验通过信息
   */
  public static final String UPPER_LIMITED_MSG_PROCESS = "process";

  /**
   * 促销计算应用默认处理方法
   * 注：如果阶梯叠加和阶梯循环叠加，该默认只适用于买赠、满减，如果时其他促销类型，请重写该方法
   * @param param
   * @return
   */
  public CalculateResultBo calculateApply(CalculateParamBo param) {
    CalculateResultBo result = new CalculateResultBo();
    result.setMatchState(false);
    if(param == null) {
      result.setMatchMsg("程序异常：传入条件参数为空");
      return result;
    }
    //获取条件规则函数
    AbstractConditionComputer conditionComputer = PromotionUtil.getBean(param.getConditionRuleFunctionBeanName(), AbstractConditionComputer.class);
    if(conditionComputer == null) {
      result.setMatchMsg(String.format("没有获取到条件规则函数，请检查配置的函数名称%s是否正确", param.getConditionRuleFunctionBeanName()));
      return result;
    }
    List<PromotionRuleEditVo.ControlRow> ladderList = param.getLadderList();
    List<PromotionRuleEditVo.ControlRow> usedLadders = Lists.newArrayList();
    if(CollectionUtil.listEmpty(ladderList)) {
      result.setMatchMsg("传入的阶梯为空:请检查促销是否配置了计算阶梯");
      return result;
    }
    boolean matchState = false;
    String matchMsg = new String();
    BigDecimal value = null;
    String valueType = null;
    String unitType = null;
    ConditionParamBo conditionParam = new ConditionParamBo();
    this.buildConditionValue(conditionParam, param.getSaleProductVos(), param.getCurrentProductVos());
    for(int i = 0; i < ladderList.size(); i++) {
      PromotionRuleEditVo.ControlRow ladder = ladderList.get(i);
      conditionParam.setLadder(ladder);
      LadderParseBo ladderParseBo = conditionComputer.parseLadder(ladder);
      conditionParam.setLadderParseBo(ladderParseBo);
      ConditionResultBo conditionResultBo = conditionComputer.conditionApply(conditionParam);
      BigDecimal multiple = conditionResultBo.getMultiple();
      BigDecimal remainder = conditionResultBo.getRemainder();
      //如果整除数大于0，说明该阶梯阶梯满足条件
      if(multiple.compareTo(BigDecimal.ZERO) == 1) {
        //过滤上限
        String upperLimitedMsg = this.validateUpperLimited(conditionResultBo.getValue(), param);
        if(!UPPER_LIMITED_MSG_PROCESS.equals(upperLimitedMsg)) {
          matchMsg = String.join(",", matchMsg, upperLimitedMsg);
          continue;
        }
        matchState = true;
        matchMsg = String.join("," ,matchMsg, String.format("匹配到第%d级阶梯", i+1));
        valueType = conditionResultBo.getValueType();
        unitType = conditionResultBo.getUnitType();
        if(value == null) {
          value = BigDecimal.ZERO;
        }
        if(conditionResultBo.getValue() != null) {
          if(SINGLE == this.getLadderType()) {
            value = value.add(conditionResultBo.getValue());
          } else {
            value = value.add(conditionResultBo.getValue().multiply(conditionResultBo.getMultiple()));
          }
        }
        usedLadders.add(ladder);
        //如果不叠加，则命中一个阶梯后不再进行下一个阶梯匹配
        if(SINGLE == getLadderType()) {
          break;
        }
        //如果阶梯买赠，则需要重新构建条件参数
        if(LADDER == getLadderType()) {
          this.refreshConditionParam(conditionParam, remainder, ladderParseBo.getSourceValueType());
        }
        //如果阶梯循环叠加，则继续匹配阶梯
        //......
      }
    }
    if(matchMsg.startsWith(",")) {
      matchMsg = matchMsg.substring(1);
    }
    result.setMatchState(matchState);
    result.setMatchMsg(matchMsg);
    result.setValue(value);
    result.setUnitType(unitType);
    result.setValueType(valueType);
    result.setLadderUsed(usedLadders);
    result.setCurrentProductVos(param.getCurrentProductVos());
    result.setGiftProductVos(param.getGiftProductVos());
    if(!matchState) {
      result.setMatchMsg("没有命中任何阶梯");
    }
    if(value != null && value.compareTo(param.getVariable()) > 0) {
      result.setMatchState(false);
      result.setMatchMsg("政策可用余量不足");
    }
    return result;
  }

  /**
   * 校验政策适用上限
   * @param value
   * @param param
   * @return
   */
  protected String validateUpperLimited(BigDecimal value, CalculateParamBo param) {
    //如果上限为null则不需要校验
    if(param.getVariable() == null) {
      return UPPER_LIMITED_MSG_PROCESS;
    }
    if(param.getVariable().compareTo(value == null ? BigDecimal.ZERO : value) < 0) {
      return "该阶梯超过政策上限，无法命中";
    }
    //如果上限校验通过，则更新原始上限数据，减去阶梯值
    param.setVariable(param.getVariable().subtract(value == null ? BigDecimal.ZERO : value));
    return UPPER_LIMITED_MSG_PROCESS;
  }

  /**
   * 解析用于阶梯计算的数量、金额、价格
   * 默认为条件类型为组合，即：汇总传入的所有商品的数量、金额
   * @param conditionParam
   * @param saleProductVos
   * @param currentProductVos
   */
  protected void buildConditionValue(ConditionParamBo conditionParam, List<PromotionSaleProductVo> saleProductVos, List<PromotionProductVo> currentProductVos) {
    if(conditionParam == null || CollectionUtil.listEmpty(saleProductVos)) {
      return;
    }
    Map<String, PromotionProductVo> currentProductVoMap;
    //如果政策本品为空，则表示整单享受
    if(CollectionUtil.listEmpty(currentProductVos)) {
      currentProductVoMap = saleProductVos.stream().collect(
              Collectors.toMap(PromotionSaleProductVo::getProductCode, a -> null, (a, b) -> a)
      );
    } else {
      currentProductVoMap = currentProductVos.stream().collect(
              Collectors.toMap(PromotionProductVo::getProductCode, a -> a, (a, b) -> a)
      );
    }
    BigDecimal count = BigDecimal.ZERO;
    BigDecimal amount = BigDecimal.ZERO;
    for(PromotionSaleProductVo productVo : saleProductVos) {
      //如果购买的该商品在政策本品列表中不存在，则不纳入计算
      PromotionProductVo currentProduct = currentProductVoMap.get(productVo.getProductCode());
      if(currentProduct == null) {
        continue;
      }
      count = count.add(productVo.getBuyCount());
      amount = amount.add(productVo.getBuyAmount());
    }
    conditionParam.setCount(count);
    conditionParam.setAmount(amount);
  }

  /**
   * 刷新条件规则参数，主要用于阶梯叠加计算
   * @param conditionParam
   * @param remainder
   * @param valueType
   */
  protected  void refreshConditionParam(ConditionParamBo conditionParam, BigDecimal remainder, String valueType) {
    BigDecimal price = (conditionParam.getCount() == null || conditionParam.getCount().compareTo(BigDecimal.ZERO) == 0) ?
                    BigDecimal.ZERO : conditionParam.getAmount().divide(conditionParam.getCount(), 6, BigDecimal.ROUND_UP);
    if(AbstractConditionComputer.NUMBER.equals(valueType)) {
      conditionParam.setCount(remainder);
      conditionParam.setAmount(remainder.multiply(price));
    } else {
      conditionParam.setAmount(remainder);
      conditionParam.setCount(remainder.divide(price, 6, BigDecimal.ROUND_UP));
    }
  }

  /**
   * 获取阶梯类型
   * 默认为不叠加
   * @return
   */
  protected int getLadderType() {
    return SINGLE;
  }




























  /****    兼容老版本     *****/
  @Override
  public CalculateRuleResponse apply(CalculateRuleParam p) {
    return new CalculateRuleResponse();
  }
  @Override
  public CalculateRuleResponse test(TestRuleParam testRuleParam) {
    return new CalculateRuleResponse();
  }
}
