package com.biz.crm.promotion.service.npromotion.beans;

import com.biz.crm.base.BusinessException;
import com.biz.crm.nebular.dms.promotion.PromotionRuleEditVo;
import com.biz.crm.nebular.dms.npromotion.bo.LadderParseBo;
import com.biz.crm.util.CollectionUtil;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;

import static com.biz.crm.eunm.dms.ControlTypeDynamicEnum.AMOUNT_AMOUNT;
import static com.biz.crm.eunm.dms.ControlTypeDynamicEnum.AMOUNT_COUNT;
import static com.biz.crm.eunm.dms.ControlTypeDynamicEnum.AMOUNT_PRICE;
import static com.biz.crm.eunm.dms.ControlTypeDynamicEnum.AMOUNT_RATIO;
import static com.biz.crm.eunm.dms.ControlTypeDynamicEnum.COUNT_AMOUNT;
import static com.biz.crm.eunm.dms.ControlTypeDynamicEnum.COUNT_COUNT;
import static com.biz.crm.eunm.dms.ControlTypeDynamicEnum.COUNT_PRICE;
import static com.biz.crm.eunm.dms.ControlTypeDynamicEnum.COUNT_RATIO;
import static com.biz.crm.eunm.dms.ControlTypeDynamicEnum.LIMITED_COUNT;
import static com.biz.crm.eunm.dms.ControlTypeDynamicEnum.NONE_PRICE;
import static com.biz.crm.eunm.dms.ControlTypeDynamicEnum.NONE_RATIO;
import static com.biz.crm.promotion.util.PromotionUtil.parseBigDecimalFromObj;
import static com.biz.crm.promotion.util.PromotionUtil.parseStringFromObj;

/**
 * 阶梯逻辑处理抽象类
 * @Author: chenrong
 * @Date: 2021/4/25 17:57
 */
public abstract class AbstractLadderService {

  /**
   * 根据阶梯类型解析阶梯控件
   * @param controls
   * @param type
   * @return
   */
  public LadderParseBo parseLadderByType(List<PromotionRuleEditVo.KeyValParamControl> controls, String type) {
    if(CollectionUtil.listEmpty(controls)) {
      return null;
    }
    //金额-金额
    if (Objects.equals(AMOUNT_AMOUNT.getCode(), type)) {
      return new LadderParseBo(
              parseBigDecimalFromObj(controls.get(0).getValue(), BigDecimal.class),
              AbstractConditionComputer.AMOUNT,
              null,
              parseBigDecimalFromObj(controls.get(1).getValue(), BigDecimal.class),
              AbstractConditionComputer.AMOUNT,
              null
      );
    }
    //金额-数量
    if (Objects.equals(AMOUNT_COUNT.getCode(), type)) {
      return new LadderParseBo(
              parseBigDecimalFromObj(controls.get(0).getValue(), BigDecimal.class),
              AbstractConditionComputer.AMOUNT,
              null,
              parseBigDecimalFromObj(controls.get(1).getValue(), BigDecimal.class),
              AbstractConditionComputer.NUMBER,
              parseStringFromObj(controls.get(2).getValue(), String.class)
      );
    }
    //金额-价格
    if (Objects.equals(AMOUNT_PRICE.getCode(), type)) {
      return new LadderParseBo(
              parseBigDecimalFromObj(controls.get(0).getValue(), BigDecimal.class),
              AbstractConditionComputer.AMOUNT,
              null,
              parseBigDecimalFromObj(controls.get(1).getValue(), BigDecimal.class),
              AbstractConditionComputer.PRICE,
              null
      );
    }
    //金额-比例
    if (Objects.equals(AMOUNT_RATIO.getCode(), type)) {
      return new LadderParseBo(
              parseBigDecimalFromObj(controls.get(0).getValue(), BigDecimal.class),
              AbstractConditionComputer.AMOUNT,
              null,
              parseBigDecimalFromObj(controls.get(1).getValue(), BigDecimal.class),
              AbstractConditionComputer.RATIO,
              null
      );
    }
    //数量-金额
    if (Objects.equals(COUNT_AMOUNT.getCode(), type)) {
      return new LadderParseBo(
              parseBigDecimalFromObj(controls.get(0).getValue(), BigDecimal.class),
              AbstractConditionComputer.NUMBER,
              parseStringFromObj(controls.get(1).getValue(), String.class),
              parseBigDecimalFromObj(controls.get(2).getValue(), BigDecimal.class),
              AbstractConditionComputer.AMOUNT,
              null
      );
    }
    //数量-数量
    if (Objects.equals(COUNT_COUNT.getCode(), type)) {
      return new LadderParseBo(
              parseBigDecimalFromObj(controls.get(0).getValue(), BigDecimal.class),
              AbstractConditionComputer.NUMBER,
              parseStringFromObj(controls.get(1).getValue(), String.class),
              parseBigDecimalFromObj(controls.get(2).getValue(), BigDecimal.class),
              AbstractConditionComputer.NUMBER,
              parseStringFromObj(controls.get(3).getValue(), String.class)
      );
    }
    //数量-价格
    if (Objects.equals(COUNT_PRICE.getCode(), type)) {
      return new LadderParseBo(
              parseBigDecimalFromObj(controls.get(0).getValue(), BigDecimal.class),
              AbstractConditionComputer.NUMBER,
              parseStringFromObj(controls.get(1).getValue(), String.class),
              parseBigDecimalFromObj(controls.get(2).getValue(), BigDecimal.class),
              AbstractConditionComputer.PRICE,
              null
      );
    }
    //数量-比例
    if (Objects.equals(COUNT_RATIO.getCode(), type)) {
      return new LadderParseBo(
              parseBigDecimalFromObj(controls.get(0).getValue(), BigDecimal.class),
              AbstractConditionComputer.NUMBER,
              parseStringFromObj(controls.get(1).getValue(), String.class),
              parseBigDecimalFromObj(controls.get(2).getValue(), BigDecimal.class),
              AbstractConditionComputer.RATIO,
              null
      );
    }
    //空值-价格
    if (Objects.equals(NONE_PRICE.getCode(), type)) {
      return new LadderParseBo(
              null,
              null,
              null,
              parseBigDecimalFromObj(controls.get(0).getValue(), BigDecimal.class),
              AbstractConditionComputer.PRICE,
              null
      );
    }
    //空值-比例
    if (Objects.equals(NONE_RATIO.getCode(), type)) {
      return new LadderParseBo(
              null,
              null,
              null,
              parseBigDecimalFromObj(controls.get(0).getValue(), BigDecimal.class),
              AbstractConditionComputer.RATIO,
              null
      );
    }
    //限量-数量
    if (Objects.equals(LIMITED_COUNT.getCode(), type)) {
      return new LadderParseBo(
              null,
              null,
              null,
              parseBigDecimalFromObj(controls.get(0).getValue(), BigDecimal.class),
              AbstractConditionComputer.NUMBER,
              null
      );
    }

    throw new BusinessException("没有匹配到传入的阶梯控件类型[%s]，如果有拓展类型请继承该类重写该方法，添加拓展类型处理逻辑", type);
  }
}
