package com.biz.crm.promotion.service.npromotion.beans.condition;

import com.biz.crm.nebular.dms.promotion.PromotionRuleEditVo;
import com.biz.crm.promotion.service.npromotion.beans.AbstractConditionComputer;
import com.biz.crm.nebular.dms.npromotion.bo.ConditionParamBo;
import com.biz.crm.nebular.dms.npromotion.bo.ConditionResultBo;
import com.biz.crm.nebular.dms.npromotion.bo.LadderParseBo;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.stereotype.Component;

import static com.biz.crm.eunm.dms.ControlTypeDynamicEnum.AMOUNT_AMOUNT;

/**
 * 无条件特价
 * 条件规则实现类
 * @Author: chenrong
 * @Date: 2021/4/23 17:28
 */
@Component(value = "NonePriceCondition")
public class NonePriceCondition extends AbstractConditionComputer {

  /**
   * 条件应用实现方法
   * @param param
   * @return
   */
  @Override
  public ConditionResultBo conditionApply(ConditionParamBo param) {
    ConditionResultBo conditionResultBo = new ConditionResultBo();
    if(param == null) {
      return conditionResultBo;
    }
    LadderParseBo ladderParseBo = param.getLadderParseBo();
    BigDecimal targetValue = ladderParseBo.getTargetValue();
    conditionResultBo.setMultiple(BigDecimal.ONE);
    conditionResultBo.setValueType(PRICE);
    conditionResultBo.setRemainder(BigDecimal.ZERO);
    conditionResultBo.setValue(targetValue);
    return conditionResultBo;
  }

  @Override
  public LadderParseBo parseLadder(PromotionRuleEditVo.ControlRow ladder) {
    List<PromotionRuleEditVo.KeyValParamControl> controls = ladder.getControls();
    //金额-金额
    LadderParseBo ladderParseBo = this.parseLadderByType(controls, AMOUNT_AMOUNT.getCode());
    return ladderParseBo;
  }
}
