package com.biz.crm.promotion.service.npromotion.beans.filters.commonfilters;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.eunm.dms.PromotionEnum;
import com.biz.crm.promotion.entity.DmsPromotionPolicyOrderDetailEntity;
import com.biz.crm.promotion.mapper.DmsPromotionPolicyOrderDetailMapper;
import com.biz.crm.promotion.service.npromotion.beans.filters.AbstractCommonFilter;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionEditVo;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionQueryReq;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CommonConstant;
import com.biz.crm.util.StringUtils;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;

/**
 * 首单享受过滤器
 * @Author: chenrong
 * @Date: 2021/4/26 11:01
 */
@Component("FirstOrderFilterImpl50")
@ConditionalOnMissingBean(name = "firstOrderFilterExtendImpl50")
public class FirstOrderFilterImpl extends AbstractCommonFilter {

  //TODO 因为订单锁定逻辑后面会重新设计，所以这里暂时直接使用mapper来做
  @Resource
  private DmsPromotionPolicyOrderDetailMapper dmsPromotionPolicyOrderDetailMapper;

  /**
   * 过滤器基础过滤方法，默认不过滤
   * @param promotions
   * @param queryReq
   */
  public List<PromotionEditVo> filter(List<PromotionEditVo> promotions, PromotionQueryReq queryReq) {
    if(CollectionUtil.listEmpty(promotions) || queryReq ==null || StringUtils.isEmpty(queryReq.getAccountCode())) {
      return Lists.newArrayList();
    }
    List<String> ids = promotions.stream().map(PromotionEditVo::getId).collect(Collectors.toList());
    LambdaQueryWrapper<DmsPromotionPolicyOrderDetailEntity> wrapper = Wrappers.lambdaQuery();
    wrapper.in(DmsPromotionPolicyOrderDetailEntity::getPromotionPolicyId, ids);
    wrapper.eq(DmsPromotionPolicyOrderDetailEntity::getCustomerCode, queryReq.getAccountCode());
    wrapper.ne(DmsPromotionPolicyOrderDetailEntity::getPolicyOrderDetailStatus, PromotionEnum.POLICY_ORDER_DETAIL.rollback.getVal());
    //根据传入政策，查询所有已使用过的政策
    List<DmsPromotionPolicyOrderDetailEntity> entities = dmsPromotionPolicyOrderDetailMapper.selectList(wrapper);
    if(CollectionUtil.listEmpty(entities)) {
      return promotions;
    }
    //筛选出所有已使用并且限首单的政策
    List<String> usedIds = entities.stream().map(DmsPromotionPolicyOrderDetailEntity::getPromotionPolicyId).collect(Collectors.toList());
    List<PromotionEditVo> usedPromotions = promotions.stream().filter(
            p -> Objects.equals(p.getFirstOrder(), CommonConstant.GLOBAL.YesOrNo.Y.getItemCode())
    && usedIds.contains(p.getId())).collect(Collectors.toList());
    //移除所有已使用并且限首单的政策
    promotions.removeAll(usedPromotions);
    return promotions;
  }
}
