package com.biz.crm.promotion.service.npromotion.beans.filters.moqfilters;

import com.biz.crm.promotion.service.npromotion.beans.filters.AbstractMoqFilter;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionEditVo;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionProductVo;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionSaleProductVo;
import com.biz.crm.promotion.util.PromotionUtil;
import java.util.List;
import java.util.Objects;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;

/**
 * 起订量过滤器实现类
 * @Author: chenrong
 * @Date: 2021/4/25 15:12
 */
@Component("MoqFilterImpl")
@ConditionalOnMissingBean(name = "moqFilterExtendImpl")
public class MoqFilterImpl extends AbstractMoqFilter {

  /**
   * 起订量筛选
   * @param promotionEditVo
   * @param saleProductVos
   */
  @Override
  public String moqApply(PromotionEditVo promotionEditVo, List<PromotionSaleProductVo> saleProductVos) {
    boolean composeState = promotionEditVo.isComposeState();
    List<PromotionProductVo> promotionCurrentProducts = promotionEditVo.getProductMap().get(PromotionUtil.PRODUCT_CURRENTS);
    //组合起订量：先校验组合起订量，再校验每个商品的起订量
    //组合商品起订量校验
    String composeMsg = this.composeProductFilter(composeState, promotionEditVo.getProductsOrderQty(),
            promotionEditVo.getProductsOrderQtyType(), promotionCurrentProducts, saleProductVos);
    //如果组合校验没有通过，则不再进行下一步
    if(!Objects.equals(composeMsg, MOQ_MATCH_MSG_OK)) {
      return composeMsg;
    }
    //每个商品起订量校验
    return this.perProductFilter(promotionCurrentProducts, saleProductVos);
  }
}
