package com.biz.crm.promotion.service.npromotion.validators;

import com.biz.crm.eunm.dms.PromotionPolicyEunm;
import com.biz.crm.eunm.dms.RuleTypeDynamicEnum;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionEditVo;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionProductVo;
import com.biz.crm.promotion.util.PromotionUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.TimeUtil;
import com.biz.crm.util.ValidateUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import lombok.SneakyThrows;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;

/**
 * 促销政策校验类
 * @Author: chenrong
 * @Date: 2021/4/13 17:04
 */
@Component
@ConditionalOnMissingBean(name = "promotionValidatorExtend")
public class PromotionValidator {

  /**
   * 校验新增促销政策入参
   * 如果有定制化校验，项目组自行重写此方法
   * @param editVo
   */
  public void validateCreate(PromotionEditVo editVo) {
    ValidateUtils.validate(editVo, "新增促销政策时，参数不能为空");
    ValidateUtils.isTrue(StringUtils.isEmpty(editVo.getId()), "新增促销政策时，id不能有值");
    ValidateUtils.validate(StringUtils.isNotEmpty(editVo.getTemplateCode()), "新增促销政策时，促销引擎编码不能为空");
    ValidateUtils.validate(StringUtils.isNotEmpty(editVo.getTemplateId()), "新增促销政策时，促销引擎id不能为空");
    ValidateUtils.validate(editVo.getPromotionType(), "新增促销政策时，促销类型不能为空");
    //校验只有促销类型为买赠时商品才能组合
//    ValidateUtils.isTrue(Objects.equals(editVo.getPromotionType(), PromotionPolicyEunm.PromotionTypeEunm.BUYGIFT.getCode())
//    || editVo.getProductMap().get(PromotionUtil.PRODUCT_CURRENTS).size() <= 1,
//            "只有促销类型为买赠时，本品才能组合，即：只有买赠可以选择多个本品");
    ValidateUtils.notEmpty(editVo.getRuleMap().get(RuleTypeDynamicEnum.CALCULATE.getObjectName()), "计算规则不能为空");
    //校验赠品比例
    this.validateRatio(editVo);
  }

  /**
   * 校验编辑促销政策入参
   * 如果有定制化校验，项目组自行重写此方法
   * @param editVo
   */
  @SneakyThrows
  public void validateUpdate(PromotionEditVo editVo) {
    ValidateUtils.validate(editVo, "编辑促销政策时，参数不能为空");
    ValidateUtils.validate(editVo.getId(), "编辑促销政策时，id不能为空");
    ValidateUtils.validate(StringUtils.isNotEmpty(editVo.getTemplateCode()), "编辑促销政策时，促销引擎编码不能为空");
    ValidateUtils.validate(StringUtils.isNotEmpty(editVo.getTemplateId()), "编辑促销政策时，促销引擎id不能为空");
    ValidateUtils.validate(editVo.getPromotionType(), "编辑促销政策时，促销类型不能为空");
    //校验只有促销类型为买赠时商品才能组合
//    ValidateUtils.isTrue(Objects.equals(editVo.getPromotionType(), PromotionPolicyEunm.PromotionTypeEunm.BUYGIFT.getCode())
//                    || editVo.getProductMap().get(PromotionUtil.PRODUCT_CURRENTS).size() <= 1,
//            "只有促销类型为买赠时，本品才能组合，即：只有买赠可以选择多个本品");
    ValidateUtils.isTrue(!"009".equals(editVo.getEnableStatus())
            || !TimeUtil.bigThan(new Date(), DateUtils.parseDate(editVo.getBeginTime(), "yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss")),
            "启用状态并且生效期内的政策不能编辑");
    ValidateUtils.notEmpty(editVo.getRuleMap().get(RuleTypeDynamicEnum.CALCULATE.getObjectName()), "计算规则不能为空");
    //校验赠品比例
    this.validateRatio(editVo);
  }

  /**
   * 校验赠品比例
   * @param editVo
   */
  public void validateRatio(PromotionEditVo editVo) {
    if(editVo == null || CollectionUtil.mapEmpty(editVo.getProductMap())
            || CollectionUtil.listEmpty(editVo.getProductMap().get(PromotionUtil.PRODUCT_GIFTS))) {
      return;
    }
    List<PromotionProductVo> gifts = editVo.getProductMap().get(PromotionUtil.PRODUCT_GIFTS);
    BigDecimal ratio = BigDecimal.ZERO;
    boolean flag = false;
    for (PromotionProductVo gift : gifts) {
      if(gift.getGiftRatio() == null) {
        flag = true;
        break;
      }
      ratio = ratio.add(gift.getGiftRatio());
    }
    //如果存在比例没有填的情况，默认全部赠送第一个赠品
    if(flag) {
      gifts.forEach(g -> g.setGiftRatio(BigDecimal.ZERO));
      gifts.get(0).setGiftRatio(BigDecimal.ONE);
      return;
    }
    ValidateUtils.isTrue(ratio.compareTo(BigDecimal.ONE) == 0, "所有赠品比例之和应该等于1");
  }

}
