package com.biz.crm.rotationpic.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.dms.rotationpic.DmsRotationPicVo;
import com.biz.crm.rotationpic.service.RotationPicService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.ArrayList;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/9/8 17:37
 **/
@Api(value = "管理端-轮播图", tags = "管理端-轮播图")
@RestController
@RequestMapping("/m/rotationpic")
public class RotationPicmController {

    @Resource
    private RotationPicService rotationPicService;


    @CrmLog
    @ApiOperation(value = "新增")
    @PostMapping(value = "add")
    public Result add(@RequestBody DmsRotationPicVo dmsRotationPicVo) {
        rotationPicService.add(dmsRotationPicVo);
        return Result.ok();
    }

    @CrmLog
    @ApiOperation(value = "编辑")
    @PostMapping(value = "edit")
    public Result edit(@RequestBody DmsRotationPicVo dmsRotationPicVo) {
        rotationPicService.edit(dmsRotationPicVo);
        return Result.ok();
    }


    @CrmLog
    @ApiOperation(value = "通过id查询")
    @PostMapping(value = "findById/{id}")
    public Result<DmsRotationPicVo> findById(@PathVariable("id") String id) {
        return Result.ok(rotationPicService.findById(id));
    }


    @CrmLog
    @ApiOperation(value = "分页搜索")
    @PostMapping(value = "list")
    public Result<PageResult<DmsRotationPicVo>> list(@RequestBody DmsRotationPicVo dmsRotationPicVo) {
        return Result.ok(rotationPicService.list(dmsRotationPicVo));
    }


    @ApiOperation(value = "根据id批量删除")
    @PostMapping(value = "delByIds")
    public Result<Object> delByIds(@RequestBody ArrayList<String> ids) {
        rotationPicService.delByIds(ids);
        return Result.ok();
    }

    @CrmLog
    @ApiOperation(value = "根据查询条件批量删除")
    @PostMapping(value = "delByParam")
    public Result<Object> delByParam(@RequestBody DmsRotationPicVo dmsRotationPicVo) {
        rotationPicService.delByParam(dmsRotationPicVo);
        return Result.ok();
    }
}
