package com.biz.crm.rotationpic.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.dms.rotationpic.DmsRotationPicVo;
import com.biz.crm.rotationpic.service.RotationPicService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

@Api(value = "PC端-轮播图", tags = "PC端-轮播图")
@RestController
@RequestMapping("/p/rotationpic")
public class RotationPicpController {

    @Resource
    private RotationPicService rotationPicService;

    @CrmLog
    @CrossOrigin
    @ApiOperation(value = "查询全部轮播图")
    @GetMapping(value = "list")
    public Result<PageResult<DmsRotationPicVo>> list(){
        DmsRotationPicVo dmsRotationPicVo = new DmsRotationPicVo();
        dmsRotationPicVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        dmsRotationPicVo.setPageNum(0);
        dmsRotationPicVo.setPageSize(500);
        dmsRotationPicVo.setSortFiled("sort_num");
        return Result.ok(rotationPicService.list(dmsRotationPicVo));
    }
}
