package com.biz.crm.rotationpic.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;



import javax.persistence.Index;


/**
 * @Description:轮播图范围
 * @Author: zhangyuzhu
 * @Date: 2020/9/11 15:43
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("dms_rotation_pic_area")
@CrmTable(name = "dms_rotation_pic_area", indexes = {
        @Index(name = "index_rotation_pic_id", columnList = "rotation_pic_id"),
        @Index(name = "i_rotation_pic_area_org_code", columnList = "org_code")
},tableNote = "轮播图范围")
public class RotationPicAreaEntity extends CrmExtEntity<RotationPicAreaEntity> {

    /**
     * 轮播图id
     */
    @CrmColumn(name = "rotation_pic_id", length = 64)
    private String rotationPicId;

    /**
     * 组织code
     */
    @CrmColumn(name = "org_code", length = 64)
    private String orgCode;

    /**
     * 组织名称
     */
    @CrmColumn(name = "org_name", length = 100)
    private String orgName;

    /**
     * 是否包含
     */
    @CrmColumn(name = "contain_flag")
    private Integer containFlag;
}
