package com.biz.crm.rotationpic.service;

import com.biz.crm.nebular.dms.rotationpic.DmsRotationPicAreaVo;

import java.util.List;
import java.util.Map;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/9/8 17:34
 **/
public interface RotationPicAreaService {

    /**
     * 替换某个轮播图的区域
     * @param areas 包含区域
     * @param noAreas 非包含区域
     * @param rotationPicId 轮播图id
     */
    void replace(List<DmsRotationPicAreaVo> areas,List<DmsRotationPicAreaVo> noAreas,String rotationPicId);


    /**
     * 根据轮播图ids批量花擦讯区域
     * @param rotationPicIds
     * @return 外层map key->轮播图id 如果没有，则为null
     *         内层mqp key->area:包含范围 noArea非包含范围 (必须有)  值：不为null
     */
    Map<String, Map<String,List<DmsRotationPicAreaVo>>> findAreaByRotationPicIds(List<String> rotationPicIds);


    /**
     * 根据轮播图ids批量花擦讯区域
     * @param rotationPicId
     * @return
     *         mqp key->area:包含范围 noArea 非包含范围 (必须有)  值：不为null
     */
    Map<String,List<DmsRotationPicAreaVo>> findAreaByRotationPicId(String rotationPicId);


    /**
     * 根据轮播图id批量删除
     * @param rotationPicIds
     */
    void delByRotationPicIds(List<String> rotationPicIds);

}
