package com.biz.crm.rotationpic.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.nebular.dms.rotationpic.DmsRotationPicAreaVo;
import com.biz.crm.rotationpic.entity.RotationPicAreaEntity;
import com.biz.crm.rotationpic.mapper.RotationPicAreaMapper;
import com.biz.crm.rotationpic.service.RotationPicAreaService;
import com.biz.crm.rotationpic.util.RotationPicAreaUtil;
import com.biz.crm.util.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2021/1/26 17:01
 **/
@ConditionalOnMissingBean(name = "rotationPicAreaServiceExpandImpl")
@Service(value = "rotationPicAreaService")
public class RotationPicAreaServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<RotationPicAreaMapper, RotationPicAreaEntity> implements RotationPicAreaService {

    @Autowired
    private RotationPicAreaMapper rotationPicAreaMapper;


    /**
     * 1、验证
     * 2、区分哪些是新增的，哪些是需要删除的
     * 3、新增，删除
     * @param areas 包含区域
     * @param noAreas 非包含区域
     * @param rotationPicId 轮播图id
     */
    @Transactional
    @Override
    public void replace(List<DmsRotationPicAreaVo> areas, List<DmsRotationPicAreaVo> noAreas, String rotationPicId) {
        //1
        List<DmsRotationPicAreaVo> allArea = new ArrayList<>();
        if(!CollectionUtils.isEmpty(areas)){
            allArea.addAll(areas);
        }
        if(!CollectionUtils.isEmpty(noAreas)){
            allArea.addAll(noAreas);
        }
        RotationPicAreaUtil.validateList(allArea);

        //2
        List<RotationPicAreaEntity> entities = rotationPicAreaMapper.selectByMap(
                new HashMap<String, Object>(){
                    {
                        put("rotation_pic_id",rotationPicId);
                    }
                }
        );
        //新增的list
        List<DmsRotationPicAreaVo> addAreas = RotationPicAreaUtil.filterAddVos(allArea,entities);
        List<String> delIds = RotationPicAreaUtil.filterDelVos(allArea,entities);

        //3
        if(!CollectionUtils.isEmpty(delIds)){
            QueryWrapper<RotationPicAreaEntity> wrapper = Wrappers.<RotationPicAreaEntity>query()
                    .in("id", delIds);
            rotationPicAreaMapper.delete(wrapper);
        }

        //新增
        if(!CollectionUtils.isEmpty(addAreas)){
            this.saveBatch(RotationPicAreaUtil.packageRntities(addAreas,rotationPicId));
        }
    }

    /**
     * 1、验证
     * 2、查询所有
     * 3、分类组装返回
     * @param rotationPicIds
     * @return
     */
    @Override
    public Map<String, Map<String, List<DmsRotationPicAreaVo>>> findAreaByRotationPicIds(List<String> rotationPicIds) {
        //1
        if(CollectionUtils.isEmpty(rotationPicIds)){
            return new HashMap<>();
        }

        //2
        QueryWrapper<RotationPicAreaEntity> wrapper = Wrappers.<RotationPicAreaEntity>query()
                .in( "rotation_pic_id", rotationPicIds);
        List<RotationPicAreaEntity> entities = rotationPicAreaMapper.selectList(wrapper);
        if(CollectionUtils.isEmpty(entities)){
            return new HashMap<>();
        }

        //3
        Map<String, Map<String, List<DmsRotationPicAreaVo>>> reMap = new HashMap<>();
        for(String rotationPicId : rotationPicIds){
            List<DmsRotationPicAreaVo> area = new ArrayList<>();
            List<DmsRotationPicAreaVo> noArea = new ArrayList<>();
            Map<String, List<DmsRotationPicAreaVo>> map = new HashMap<String, List<DmsRotationPicAreaVo>>(){
                {
                    put("area",area);
                    put("noArea",noArea);
                }
            };
            reMap.put(rotationPicId,map);
            List<RotationPicAreaEntity> entityList = entities.stream().filter(entity -> entity.getRotationPicId().equals(rotationPicId)).collect(Collectors.toList());;
            if(CollectionUtils.isEmpty(entityList)){
                continue;
            }
            for(RotationPicAreaEntity entity : entityList){
                DmsRotationPicAreaVo vo = new DmsRotationPicAreaVo();
                BeanUtils.copyProperties(entity,vo);
                if(vo.getContainFlag().intValue() == YesNoEnum.YesNoCodeNumberEnum.YES.getCode().intValue()){
                    area.add(vo);
                    continue;
                }
                noArea.add(vo);
            }
        }
        return reMap;
    }

    /**
     * 1、验证
     * 2、查询出所有的区域
     * 3、区分组装并返回
     * @param rotationPicId
     * @return
     */
    @Override
    public Map<String, List<DmsRotationPicAreaVo>> findAreaByRotationPicId(String rotationPicId) {
        //1
        List<DmsRotationPicAreaVo> area = new ArrayList<>();
        List<DmsRotationPicAreaVo> noArea = new ArrayList<>();
        Map<String, List<DmsRotationPicAreaVo>> reMap = new HashMap<String, List<DmsRotationPicAreaVo>>(){
            {
                put("area",area);
                put("noArea",noArea);
            }
        };
        if(StringUtils.isEmpty(rotationPicId)){
            return reMap;
        }

        //2
        List<RotationPicAreaEntity> entities = rotationPicAreaMapper.selectByMap(
                new HashMap<String, Object>(){
                    {
                        put("rotation_pic_id",rotationPicId);
                    }
                }
                );
        if(CollectionUtils.isEmpty(entities)){
            return reMap;
        }

        //3
        for(RotationPicAreaEntity entity : entities){
            DmsRotationPicAreaVo vo = new DmsRotationPicAreaVo();
            BeanUtils.copyProperties(entity,vo);
            if(vo.getContainFlag().intValue() == YesNoEnum.YesNoCodeNumberEnum.YES.getCode().intValue()){
                area.add(vo);
                continue;
            }
            noArea.add(vo);
        }
        return reMap;
    }

    @Transactional
    @Override
    public void delByRotationPicIds(List<String> rotationPicIds) {
        QueryWrapper<RotationPicAreaEntity> wrapper = Wrappers.<RotationPicAreaEntity>query()
                .in( "rotation_pic_id", rotationPicIds);
        rotationPicAreaMapper.delete(wrapper);
    }
}
