package com.biz.crm.salecontract.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.dms.salecontract.SaleContractVo;
import com.biz.crm.salecontract.service.SaleContractService;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.util.ValidateUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * PC端-合同接口
 * @Author: chenrong
 * @Date: 2021/3/1 10:41
 */
@Api(value = "PC端-合同接口", tags = "PC端-合同接口")
@RestController
@RequestMapping(value = "/p/saleContract")
public class SaleContractpController {

  @Resource
  private SaleContractService saleContractService;

  @CrmLog
  @ApiOperation(value = "查询某客户的所有合同")
  @PostMapping("findContractPageByConditions")
  public Result<PageResult<SaleContractVo>> findContractPageByConditions(@RequestBody SaleContractVo contractVo) {
    UserRedis user = UserUtils.getUser();
    ValidateUtils.validate(user, "没有获取到当前登录用户，请先登录");
    String cusCode = user.getCustcode();
    ValidateUtils.validate(cusCode, "没有获取到当前登陆人客户编码，请确认该用户是否合法");
    contractVo.setCusCode(cusCode);
    PageResult<SaleContractVo> result = this.saleContractService.findContractPageByConditions(contractVo);
    return Result.ok(result);
  }

  @CrmLog
  @ApiOperation(value = "查询合同详情")
  @GetMapping("findDetailsByCode")
  public Result<SaleContractVo> findDetailsByCode(@RequestParam @ApiParam(value = "合同编码") String code) {
    SaleContractVo result = this.saleContractService.findDetailByCode(code);
    return Result.ok(result);
  }

  @CrmLog
  @ApiOperation("签约")
  @PostMapping("sign")
  public Result<SaleContractVo> sign(@RequestBody SaleContractVo vo) {
    SaleContractVo result = this.saleContractService.sign(vo);
    return Result.ok(result);
  }

}
