package com.biz.crm.salecontract.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;



import javax.persistence.Index;


/**
 * 合同模板
 * @Author: chenrong
 * @Date: 2021/2/4 10:19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("dms_contract_template")
@CrmTable(name = "dms_contract_template", indexes = {
        @Index(name = "i_contract_template_contract_type", columnList = "contract_type"),
        @Index(name = "i_contract_template_org_code", columnList = "org_code")
},tableNote = "合同模板")
public class ContractTemplateEntity extends CrmExtEntity {

  private static final long serialVersionUID = -3134549498253794666L;

  /****基础信息****/
  /**
   * 合同模板编码
   */
  @CrmColumn(name = "code", unique = true, length = 64)
  private String code;
  /**
   * 合同模板名称
   */
  @CrmColumn(name = "name", length = 100)
  private String name;
  /**
   * 合同类型
   */
  @CrmColumn(name = "contract_type")
  private Integer contractType;
  /**
   * 组织编码
   */
  @CrmColumn(name = "org_code", length = 64)
  private String orgCode;
  /**
   * 组织名称
   */
  @CrmColumn(name = "org_name", length = 100)
  private String orgName;
  /**
   * 开始时间
   */
  @CrmColumn(name = "start_time", length = 20)
  private String startTime;
  /**
   * 结束时间
   */
  @CrmColumn(name = "end_time", length = 20)
  private String endTime;

}
