package com.biz.crm.salecontract.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;



import javax.persistence.Index;


/**
 * 合同模板元组映射实体
 * @Author: chenrong
 * @Date: 2021/2/5 10:49
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("dms_contract_template_tuple_mapping")
@CrmTable(name = "dms_contract_template_tuple_mapping", indexes = {
        @Index(name = "i_contract_template_template_code", columnList = "template_code"),
        @Index(name = "index_tuple_code", columnList = "tuple_code"),
        @Index(name = "unique_mapping", columnList = "template_code,tuple_code,index_code", unique = true)
},tableNote = "合同模板元组映射实体")
public class ContractTemplateTupleMappingEntity extends CrmExtTenEntity {

  private static final long serialVersionUID = 2844154243437158771L;
  /**
   * 合同模板编码
   */
  @CrmColumn(name = "template_code", length = 64)
  private String templateCode;
  /**
   * 合同元组编码
   */
  @CrmColumn(name = "tuple_code", length = 64)
  private String tupleCode;
  /**
   * 元组再模板中展示顺序
   */
  private Integer tupleIndex;
  /**
   * 数据检索编码
   */
  @CrmColumn(name = "index_code", length = 64)
  private String indexCode;

}
