package com.biz.crm.salecontract.service;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.dms.salecontract.ContractTemplateVo;
import java.util.List;

/**
 * 合同模板逻辑处理类
 * @Author: chenrong
 * @Date: 2021/2/5 11:20
 */
public interface ContractTemplateService {
  /**
   * 新增合同模板
   * @param contractTemplateVo
   * @return
   */
  ContractTemplateVo add(ContractTemplateVo contractTemplateVo);

  /**
   * 编辑合同模板
   * @param contractTemplateVo
   * @return
   */
  ContractTemplateVo edit(ContractTemplateVo contractTemplateVo);

  /**
   * 根据编码查询合同模板
   * @param code
   * @return
   */
  ContractTemplateVo findByCode(String code);

  /**
   * 分页条件查询合同模板
   * @param contractTemplateVo
   * @return
   */
  PageResult<ContractTemplateVo> findPageByConditions(ContractTemplateVo contractTemplateVo);

  /**
   * 根据模板编码查询详情
   * @param code 模板编码
   * @return
   */
  ContractTemplateVo findDetailsByCode(String code);

  /**
   * 批量启用模板
   * @param ids
   */
  void enableBatch(List<String> ids);

  /**
   * 批量禁用模板
   * @param ids
   */
  void disableBatch(List<String> ids);
}
