package com.biz.crm.salecontract.service.extral;

import com.biz.crm.base.BusinessException;
import com.biz.crm.nebular.dms.salecontract.SaleContractVo;
import com.biz.crm.util.ValidateUtils;

/**
 * 暴露给业务系统实现的合同校验类
 * 校验参数工具类，建议使用：{@link ValidateUtils}
 * 异常类，建议使用：{@link BusinessException}
 * @Author: chenrong
 * @Date: 2021/3/19 11:46
 */
public interface SaleContractValidator {

  /**
   * 新增校验
   * 如果没有特殊需求，请不要修改对象属性
   * @param saleContractVo
   */
  void validateAdd(SaleContractVo saleContractVo);

  /**
   * 编辑校验
   * 如果没有特殊需求，请不要修改对象属性
   * @param saleContractVo
   */
  void validateEdit(SaleContractVo saleContractVo);
}
