package com.biz.crm.salecontract.service.listener.impl;

import com.alibaba.fastjson.JSONArray;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.crmlog.handle.util.CrmLogUtil;
import com.biz.crm.eunm.mdm.AvailableListRuleEnum;
import com.biz.crm.mdm.availablelistrule.AvailableListRuleFeign;
import com.biz.crm.nebular.dms.salecontract.SaleContractVo;
import com.biz.crm.nebular.mdm.availablelistrule.AvailableListRuleAreaVo;
import com.biz.crm.nebular.mdm.availablelistrule.AvailableListRuleVo;
import com.biz.crm.salecontract.service.listener.AbstractContractModelListener;
import com.biz.crm.util.*;
import com.google.common.collect.Lists;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * 可够商品
 * @author liufan E-mail:fan.liu@biz-united.com.cn
 * @version 创建时间：2021/2/22
 */
@Service("contractAvailableGoodsListener")
@ConditionalOnMissingBean(name = "contractAvailableGoodsListenerExtend")
public class ContractAvailableGoodsListener implements AbstractContractModelListener {
  @Resource
  private AvailableListRuleFeign availableListRuleFeign;

  /**
   * 新增可购商品
   * 1、获取参数
   * 2、设置参数
   * 3、调用方法保存
   * 4、包装返回结果        对象数据（列表）
   * @param contractCode 合同编码
   * @param jsonName     数据对象名称，一般情况下不会用到，如果多个模块实现同一个接口，该参数可以做区分使用
   * @param saleContractVo
   * @param indexCode
   * @return
   */
  @Override
  @Transactional
  public JSONArray add(JSONArray data, String contractCode, String jsonName, SaleContractVo saleContractVo, String indexCode) {
    ValidateUtils.validate(contractCode, "合同编码不能为空");
    ValidateUtils.validate(saleContractVo, "合同不能为空");
    //1
    List<AvailableListRuleVo> vos = BeanCopyUtil.parseByJSONArray(data, AvailableListRuleVo.class);
    ValidateUtils.isTrue(CollectionUtil.listNotEmpty(vos), "可购商品不为空");
    //2
    AvailableListRuleVo availableListRuleVo = vos.get(0);
    if (!StringUtils.isEmpty(availableListRuleVo.getId())) {
      return this.edit(data, contractCode, jsonName, saleContractVo, indexCode);
    }
    availableListRuleVo.setSourceId(contractCode);
    AvailableListRuleAreaVo areaVo = new AvailableListRuleAreaVo();
    areaVo.setCusOrgCode(saleContractVo.getOrgCode());
    areaVo.setCusOrgName(saleContractVo.getOrgName());
    areaVo.setCusCode(saleContractVo.getCusCode());
    areaVo.setCusName(saleContractVo.getCusName());
    areaVo.setCusChannelCode(saleContractVo.getChannelCode());
    areaVo.setCusChannelName(saleContractVo.getChannelName());
    ArrayList<AvailableListRuleAreaVo> areaVos = Lists.newArrayList(areaVo);
    availableListRuleVo.setAreaes(areaVos);
    //3
    Result result = availableListRuleFeign.addForConstract(availableListRuleVo);
    ValidateUtils.isTrue(result.isSuccess(), "调用可购接口失败："+result.getMessage());
    //4
    JSONArray jsonArray = BeanCopyUtil.formatJSONArray(Lists.newArrayList(result));
    return jsonArray;
  }

  /**
   * 编辑可购商品
   * 1、获取参数
   * 2、设置参数
   * 3、调用方法保存
   * 4、包装返回结果
   * @param data           对象数据（列表）
   * @param contractCode   合同编码
   * @param jsonName       数据对象名称，一般情况下不会用到，如果多个模块实现同一个接口，该参数可以做区分使用
   * @param saleContractVo
   * @param indexCode
   * @return
   */
  @Override
  @Transactional
  public JSONArray edit(JSONArray data, String contractCode, String jsonName, SaleContractVo saleContractVo, String indexCode) {
    ValidateUtils.validate(contractCode, "合同编码不能为空");
    ValidateUtils.validate(saleContractVo, "合同不能为空");
    //1
    List<AvailableListRuleVo> vos = BeanCopyUtil.parseByJSONArray(data, AvailableListRuleVo.class);
    ValidateUtils.isTrue(CollectionUtil.listNotEmpty(vos), "可购商品不为空");
    //2
    AvailableListRuleVo availableListRuleVo = vos.get(0);
    if (StringUtils.isEmpty(availableListRuleVo.getId())) {
      return this.add(data, contractCode, jsonName, saleContractVo, indexCode);
    }
    availableListRuleVo.setSourceId(contractCode);
    AvailableListRuleAreaVo areaVo = new AvailableListRuleAreaVo();
    areaVo.setCusOrgCode(saleContractVo.getOrgCode());
    areaVo.setCusOrgName(saleContractVo.getOrgName());
    areaVo.setCusCode(saleContractVo.getCusCode());
    areaVo.setCusName(saleContractVo.getCusName());
    areaVo.setCusChannelCode(saleContractVo.getChannelCode());
    areaVo.setCusChannelName(saleContractVo.getChannelName());
    ArrayList<AvailableListRuleAreaVo> areaVos = Lists.newArrayList(areaVo);
    availableListRuleVo.setAreaes(areaVos);
    //3
    Result result = availableListRuleFeign.edit(availableListRuleVo);
    ValidateUtils.isTrue(result.isSuccess(), "调用可购接口失败："+result.getMessage());
    //4
    JSONArray jsonArray = BeanCopyUtil.formatJSONArray(Lists.newArrayList(result));
    return jsonArray;
  }

  /**
   * 根据合同和数据缩影查询可购商品
   * 1、调用服务返回查询结果
   * 2、包装并返回结果
   * @param contractCode 合同编码
   * @param jsonName     数据对象名称，一般情况下不会用到，如果多个模块实现同一个接口，该参数可以做区分使用
   * @param indexCode
   * @return
   */
  @Override
  public JSONArray findByContractCode(String contractCode, String jsonName, String indexCode) {
    //1、调用服务返回查询结果
    Result<AvailableListRuleVo> result = availableListRuleFeign.findBySourceId(contractCode);
    ValidateUtils.isTrue(result.isSuccess(), "调用可购接口失败："+result.getMessage());
    //2、包装并返回结果
    return BeanCopyUtil.formatJSONArray(Lists.newArrayList(result));
  }
}
