package com.biz.crm.salecontract.service.listener.impl;

import com.alibaba.fastjson.JSONArray;
import com.biz.crm.nebular.dms.salecontract.SaleContractVo;
import com.biz.crm.nebular.dms.salesarea.SalesAreaVo;
import com.biz.crm.salecontract.service.listener.AbstractContractModelListener;
import com.biz.crm.salesarea.service.SalesAreaService;
import com.biz.crm.util.BeanCopyUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.ValidateUtils;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import org.springframework.transaction.annotation.Transactional;

/**
 * 销售范围
 * @author liufan E-mail:fan.liu@biz-united.com.cn
 * @version 创建时间：2021/2/22
 */
@Service("contractSalesAreaListener")
@ConditionalOnMissingBean(name = "contractSalesAreaListenerExtend")
public class ContractSalesAreaListener implements AbstractContractModelListener {
  @Resource
  private SalesAreaService salesAreaService;

  @Override
  @Transactional
  public JSONArray add(JSONArray data, String contractCode, String jsonName, SaleContractVo saleContractVo, String indexCode) {
    //1、校验入参
    if(CollectionUtil.jsonArrayEmpty(data)) {
      return new JSONArray();
    }
    //2、更新数据
    return this.edit(data, contractCode, jsonName, saleContractVo, indexCode);
  }

  /**
   * @param data         对象数据（列表）
   * @param contractCode 合同编码
   * @param jsonName     数据对象名称，一般情况下不会用到，如果多个模块实现同一个接口，该参数可以做区分使用
   * @param saleContractVo
   * @param indexCode
   * @return
   */
  @Override
  @Transactional
  public JSONArray edit(JSONArray data, String contractCode, String jsonName, SaleContractVo saleContractVo, String indexCode) {
    //1、校验入参
    ValidateUtils.validate(contractCode, "合同编码不能为空");
    ValidateUtils.validate(saleContractVo, "合同不能为空");
    //2、获取参数
    List<SalesAreaVo> vos = BeanCopyUtil.parseByJSONArray(data, SalesAreaVo.class);
    //3、调用方法保存
    List<SalesAreaVo> result = salesAreaService.replaceSalesArea(vos, contractCode);
    //4、包装返回结果
    return BeanCopyUtil.formatJSONArray(result);
  }

  @Override
  public JSONArray findByContractCode(String contractCode, String jsonName, String indexCode) {
    //调用服务返回查询结果
    SalesAreaVo result = salesAreaService.listSalesArea(contractCode);
    //包装结果
    JSONArray jsonArray = new JSONArray();
    jsonArray.add(result);
    return jsonArray;
  }
}
