package com.biz.crm.salecontract.util;

import com.biz.crm.nebular.dms.salecontract.ContractTemplateTupleMappingVo;
import com.biz.crm.nebular.dms.salecontract.ContractTemplateVo;
import com.biz.crm.nebular.dms.salecontract.ContractTupleVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.ValidateUtils;
import com.google.common.collect.Lists;
import java.util.List;

/**
 * 合同模板工具处理类
 * @Author: chenrong
 * @Date: 2021/2/5 11:43
 */
public class ContractTemplateUtil {

  /**
   * 校验新增合同模板参数
   * @param contractTemplateVo
   */
  public static void validateAdd(ContractTemplateVo contractTemplateVo) {
    ValidateUtils.validate(contractTemplateVo, "合同模板不能为空");
    ValidateUtils.notEmpty(contractTemplateVo.getTuples(), "元组列表不能为空");
    ValidateUtils.validate(contractTemplateVo.getName(), "合同模板名称不能为空");
    contractTemplateVo.getTuples().forEach(tuple -> {
      ValidateUtils.validate(tuple.getCode(), "元组编码不能为空");
      ValidateUtils.validate(tuple.getTupleIndex(), "元组序号不能为空");
      ValidateUtils.validate(tuple.getJsonName(), "元组对象名称不能为空");
    });
  }

  /**
   * 构建模板和元组映射新增/编辑参数
   * @param tupleVos
   * @param templateCode
   */
  public static List<ContractTemplateTupleMappingVo> buildTemplateTupleMappingVo(List<ContractTupleVo> tupleVos, String templateCode) {
    if(CollectionUtil.listEmpty(tupleVos)) {
      return Lists.newArrayList();
    }
    ValidateUtils.validate(templateCode, "构建模板和元组映射新增/编辑参数时，模板编码不能为空");
    List<ContractTemplateTupleMappingVo> result = Lists.newArrayList();
    tupleVos.forEach(tuple -> {
      ContractTemplateTupleMappingVo mappingVo = new ContractTemplateTupleMappingVo();
      mappingVo.setTemplateCode(templateCode);
      mappingVo.setTupleIndex(tuple.getTupleIndex());
      mappingVo.setJsonName(tuple.getJsonName());
      mappingVo.setTupleCode(tuple.getCode());
      result.add(mappingVo);
    });
    return result;
  }

  /**
   * 校验编辑合同模板参数
   * @param contractTemplateVo
   */
  public static void validateEdit(ContractTemplateVo contractTemplateVo) {
    validateAdd(contractTemplateVo);
    ValidateUtils.validate(contractTemplateVo.getId(), "编辑模板时，模板id不能为空");
    ValidateUtils.validate(contractTemplateVo.getCode(), "编辑模板时，模板编码不能为空");
  }
}
