package com.biz.crm.salecontract.util;

import com.biz.crm.nebular.dms.salecontract.ContractTupleVo;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.ValidateUtils;

/**
 * 合同元组工具类
 * @Author: chenrong
 * @Date: 2021/2/5 10:20
 */
public class ContractTupleUtil {

  /**
   * 校验新增合同元组参数
   * @param contractTupleVo
   */
  public static void validateAdd(ContractTupleVo contractTupleVo) {
    ValidateUtils.validate(contractTupleVo, "元组参数不能为空");
    ValidateUtils.validate(contractTupleVo.getName(), "元组名称不能为空");
    ValidateUtils.isTrue(StringUtils.isNotEmpty(contractTupleVo.getRelativePath()) || StringUtils.isNotEmpty(contractTupleVo.getRouterPath()),
            "元组相对路径和路由路径不能同时为空");
  }

  /**
   * 校验编辑合同元组参数
   * @param contractTupleVo
   */
  public static void validateEdit(ContractTupleVo contractTupleVo) {
    validateAdd(contractTupleVo);
    ValidateUtils.validate(contractTupleVo.getCode(), "元组编码不能为空");
  }
}
