package com.biz.crm.salegoal.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.dms.salegoal.SaleGoalVo;
import com.biz.crm.salegoal.service.SaleGoalService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/9/8 17:37
 **/
@Api(value = "管理端-销售目标（新）", tags = "管理端-销售目标（新）")
@RestController
@RequestMapping("/m/saleGoal")
public class SaleGoalmController {

  @Resource
  private SaleGoalService saleGoalService;

  @CrmLog
  @ApiOperation(value = "批量新增")
  @PostMapping(value = "addBatch")
  public Result addBatch(@RequestBody List<SaleGoalVo> saleGoalVos) {
    saleGoalService.addBatch(saleGoalVos);
    return Result.ok();
  }

  @CrmLog
  @ApiOperation(value = "编辑")
  @PostMapping(value = "edit")
  public Result edit(@RequestBody SaleGoalVo saleGoalVo) {
    saleGoalService.edit(saleGoalVo);
    return Result.ok();
  }

  @CrmLog
  @ApiOperation(value = "通过id查询")
  @GetMapping(value = "findById/{id}")
  public Result<SaleGoalVo> findById(@PathVariable("id") String id) {
    return Result.ok(saleGoalService.findById(id));
  }

  @CrmLog
  @ApiOperation(value = "分页搜索")
  @PostMapping(value = "list")
  public Result<PageResult<SaleGoalVo>> list(@RequestBody SaleGoalVo saleGoalVo) {
    return Result.ok(saleGoalService.list(saleGoalVo));
  }

  @ApiOperation(value = "根据id批量删除")
  @PostMapping(value = "delByIds")
  public Result<Object> delByIds(@RequestBody ArrayList<String> ids) {
    saleGoalService.delByIds(ids);
    return Result.ok();
  }

  @CrmLog
  @ApiOperation(value = "根据查询条件批量删除")
  @PostMapping(value = "delByParam")
  public Result<Object> delByParam(@RequestBody SaleGoalVo saleGoalVo) {
    saleGoalService.delByParam(saleGoalVo);
    return Result.ok();
  }
}
