package com.biz.crm.salegoal.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.persistence.Index;
import java.math.BigDecimal;

/**
 * @Description:销售目标
 * @Author: zhangyuzhu
 * @Date: 2020/9/11 15:43
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("dms_sale_goal")
@CrmTable(name = "dms_sale_goal", indexes = {
        @Index(name = "sale_goal_cus_code", columnList = "cus_code"),
        @Index(name = "sale_goal_cus_org_code", columnList = "cus_org_code"),
        @Index(name = "sale_goal_cus_channel_code", columnList = "cus_channel_code"),
        @Index(name = "sale_goal_target_year", columnList = "target_year"),
        @Index(name = "sale_goal_goods_code", columnList = "goods_code"),
        @Index(name = "index_contract_code_index_code", columnList = "contract_code,index_code")
},tableNote = "销售目标")
public class SaleGoalEntity extends CrmExtTenEntity<SaleGoalEntity> {


  /**
   * 客户编码
   */
  @CrmColumn(name = "cus_code", length = 64)
  private String cusCode;

  /**
   * 客户名称
   */
  @CrmColumn(name = "cus_name", length = 200)
  private String cusName;

  /**
   * 客户所属组织编码
   */
  @CrmColumn(name = "cus_org_code", length = 64)
  private String cusOrgCode;

  /**
   * 客户所属组织名称
   */
  @CrmColumn(name = "cus_org_name", length = 200)
  private String cusOrgName;

  /**
   * 客户所属渠道编码
   */
  @CrmColumn(name = "cus_channel_code", length = 20)
  private String cusChannelCode;

  /**
   * 客户所属渠道名称
   */
  @CrmColumn(name = "cus_channel_name", length = 64)
  private String cusChannelName;


  /**
   * 销售区域编码
   */
  @CrmColumn(name = "sales_area_code", length = 40)
  private String salesAreaCode;

  /**
   * 销售区域名称
   */
  @CrmColumn(name = "sales_area_name", length = 200)
  private String salesAreaName;


  /**
   * 销量目标类型
   * 枚举：{@link com.biz.crm.eunm.dms.SaleGoalEunm.GoalType}
   */
  private Integer type;

  /**
   * 销量目标名称
   */
  @CrmColumn(name = "name", length = 200)
  private String name;

  /**
   * 目标年份
   */
  @CrmColumn(name = "target_year", length = 20)
  private Integer targetYear;

  /**
   * 目标年份总量
   */
  private BigDecimal targetNum;

  /**
   * 商品编码(类型是单品销售目标 该字段不能空)
   */
  @CrmColumn(name = "goods_code", length = 64)
  private String goodsCode;

  /**
   * 商品名称(类型是单品销售目标 该字段不能空)
   */
  @CrmColumn(name = "goods_name", length = 200)
  private String goodsName;

  /**
   * 商品规格(类型是单品销售目标 该字段不能空)
   */
  @CrmColumn(name = "product_spec", length = 64)
  private String productSpec;

  /**
   * 产品层级code(类型是非常规 该字段不能空)
   */
  @CrmColumn(name = "product_level_code", length = 40)
  private String productLevelCode;

  /**
   * 产品层级名称(类型是非常规 该字段不能空)
   */
  @CrmColumn(name = "product_level_name", length = 200)
  private String productLevelName;

  /**
   * 唯一值，去重时查询用 (类型是单品：产品code + 目标年份 ；类型是层级：产品层级code + 目标年份;类型是常规： 目标年份)
   */
  @CrmColumn(name = "only_key", length = 40)
  private String onlyKey;

  /**
   * 对象维度，用户、组织、终端
   * 枚举：{@link com.biz.crm.eunm.dms.SaleGoalEunm.ObjectType}
   */
  private Integer objectType;

  /**
   * 任务类型，年目标、季度目标、月度目标
   * 枚举：{@link com.biz.crm.eunm.dms.SaleGoalEunm.TaskType}
   */
  private Integer taskType;

  /**
   * 组织编码（对象维度为组织时，选择）
   */
  @CrmColumn(name = "org_code", length = 64)
  private String orgCode;

  /**
   * 组织名称
   */
  @CrmColumn(name = "org_name", length = 200)
  private String orgName;

  /**
   * 终端编码
   */
  @CrmColumn(name = "terminal_code", length = 64)
  private String terminalCode;

  /**
   * 终端名称
   */
  @CrmColumn(name = "terminal_name", length = 200)
  private String terminalName;

  /**
   * 合同编码
   */
  @CrmColumn(name = "contract_code", length = 64)
  private String contractCode;

  /**
   * 数据检索编码
   */
  @CrmColumn(name = "index_code", length = 64)
  private String indexCode;

  /**
   * 审批状态
   */
  @CrmColumn(name = "sure_state", length = 10)
  private String sureState;

  /**
   * 销量目标分摊，枚举：{@link com.biz.crm.eunm.dms.SaleGoalEunm.SharingType}
   */
  @CrmColumn(name = "sharing_type", length = 20)
  private String sharingType = "none";

//  /**
//   * 单位类型(字典-saleGoal_unitType)
//   */
//  private String unitType;

  @CrmColumn(name = "unit_code", length = 64, note = "单位编码")
  private String unitCode;
}
