package com.biz.crm.salegoal.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;



import javax.persistence.Index;

import java.math.BigDecimal;

/**
 * @Description:销售月目标
 * @Author: zhangyuzhu
 * @Date: 2020/9/11 15:43
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("dms_sale_goal_item")
@CrmTable(name = "dms_sale_goal_item",indexes = {
        @Index(name = "index_sale_goal_id", columnList = "sale_goal_id")
},tableNote = "销售月目标")
public class SaleGoalItemEntity extends CrmExtTenEntity<SaleGoalItemEntity> {

  /**
   * 销售目标id
   */
  @CrmColumn(name = "sale_goal_id",length = 40)
  private String saleGoalId;

  /**
   * 一月目标销量
   */
  private BigDecimal janTargetNum;

  /**
   * 二月目标销量
   */
  private BigDecimal febTargetNum;

  /**
   * 三月目标销量
   */
  private BigDecimal marTargetNum;

  /**
   * 四月目标销量
   */
  private BigDecimal aprTargetNum;

  /**
   * 五月目标销量
   */
  private BigDecimal mayTargetNum;

  /**
   * 六月目标销量
   */
  private BigDecimal junTargetNum;

  /**
   * 七月目标销量
   */
  private BigDecimal julTargetNum;

  /**
   * 八月目标销量
   */
  private BigDecimal augTargetNum;

  /**
   * 九月目标销量
   */
  private BigDecimal sepTargetNum;

  /**
   * 十月目标销量
   */
  private BigDecimal octTargetNum;

  /**
   * 十一月目标销量
   */
  private BigDecimal novTargetNum;

  /**
   * 十二月目标销量
   */
  private BigDecimal decTargetNum;

  /**
   * 第一季度目标销量
   */
  private BigDecimal firstQuarterNum;
  /**
   * 第二季度目标销量
   */
  private BigDecimal secondQuarterNum;
  /**
   * 第三季度目标销量
   */
  private BigDecimal thirdQuarterNum;
  /**
   * 第四季度目标销量
   */
  private BigDecimal fourthQuarterNum;
  /**
   * 年度目标销量
   */
  private BigDecimal yearlyNum;
  /**
   * 第一季度目标销量汇总
   */
  private BigDecimal firstQuarterSum;
  /**
   * 第二季度目标销量汇总
   */
  private BigDecimal secondQuarterSum;
  /**
   * 第三季度目标销量汇总
   */
  private BigDecimal thirdQuarterSum;
  /**
   * 第四季度目标销量汇总
   */
  private BigDecimal fourthQuarterSum;
  /**
   * 年度目标销量
   */
  private BigDecimal yearlySum;
}
