package com.biz.crm.salegoal.service;

import com.biz.crm.nebular.dms.salecontract.SaleContractVo;
import com.biz.crm.nebular.dms.salegoal.SaleGoalRatioVo;

/**
 * 获取销售目标月度比例
 * @Author: chenrong
 * @Date: 2021/2/25 17:37
 */
public interface SaleGoalRatioService {

  /**
   * 根据合同信息（年度+类型+所属组织+开始时间）获取月度比例明细接口
   * @param targetYear  目标年份
   * @param contractVo  合同对象，其中包含了渠道类型(channelCode)，组织(orgCode)，开始时间(startTime)，合同年度(yearly)
   * @return
   */
  SaleGoalRatioVo findMonthRatio(Integer targetYear, SaleContractVo contractVo);
}
