package com.biz.crm.salegoal.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.nebular.dms.salegoal.SaleGoalItemVo;
import com.biz.crm.salegoal.entity.SaleGoalItemEntity;
import com.biz.crm.salegoal.mapper.SaleGoalItemMapper;
import com.biz.crm.salegoal.service.SaleGoalItemService;
import com.biz.crm.salegoal.utils.SaleGoalItemUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.ValidateUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/9/15 16:12
 **/
@ConditionalOnMissingBean(name = "saleGoalItemServiceImpl")
@Service(value = "saleGoalItemService")
public class SaleGoalItemServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<SaleGoalItemMapper, SaleGoalItemEntity> implements SaleGoalItemService {

  @Resource
  private SaleGoalItemMapper saleGoalItemMapper;

  @Override
  public void addBatch(List<SaleGoalItemVo> saleGoalItemVos) {
    if (CollectionUtils.isEmpty(saleGoalItemVos)) {
      return;
    }
    List<SaleGoalItemEntity> entities = new ArrayList<>(saleGoalItemVos.size());
    for (SaleGoalItemVo vo : saleGoalItemVos) {
      if (vo == null) {
        throw new BusinessException("月目标详情必填！");
      }
      entities.add(SaleGoalItemUtil.packageEntityForAddBatch(vo));
    }
    this.saveBatch(entities);
  }


  /**
   * 1、验证
   * 2、组装更新
   * @param saleGoalItemVo
   */
  @Override
  public void update(SaleGoalItemVo saleGoalItemVo) {
    //1
    ValidateUtils.validate(saleGoalItemVo.getId(), "请指定要编辑的销售目标明细!");
    SaleGoalItemEntity entity = saleGoalItemMapper.selectById(saleGoalItemVo.getId());
    ValidateUtils.validate(entity, "您要编辑的销售目标明细不存在或者已经被删除!");

    //2
    SaleGoalItemEntity currentEntity = SaleGoalItemUtil.packageEntityForUpdate(saleGoalItemVo);
    saleGoalItemMapper.updateById(currentEntity);
  }

  /**
   * @param salesTargetId
   * @return
   */
  @Override
  public SaleGoalItemVo findBySaleGoalId(String salesTargetId) {
    QueryWrapper<SaleGoalItemEntity> wrapper = new QueryWrapper<>();
    wrapper.eq("sale_goal_id", salesTargetId);
    List<SaleGoalItemEntity> saleGoalItemEntityList = saleGoalItemMapper.selectList(wrapper);
    if(CollectionUtil.listEmpty(saleGoalItemEntityList)) {
      return null;
    }
    SaleGoalItemVo vo = new SaleGoalItemVo();
    BeanUtils.copyProperties(saleGoalItemEntityList.get(0), vo);
    SaleGoalItemUtil.salesTargetToStr(vo);
    return vo;
  }

  /**
   * 1、验证
   * 2、查询组装返回
   * @param saleGoalIds
   * @return
   */
  @Override
  public Map<String, SaleGoalItemVo> findBySaleGoalIds(List<String> saleGoalIds) {
    //1
    Map<String, SaleGoalItemVo> reMap = new HashMap<>();
    if (CollectionUtils.isEmpty(saleGoalIds)) {
      return reMap;
    }

    //2
    QueryWrapper<SaleGoalItemEntity> wrapper = new QueryWrapper<>();
    wrapper.in("sale_goal_id", saleGoalIds);
    List<SaleGoalItemEntity> monthTargetEntities = saleGoalItemMapper.selectList(wrapper);
    Map<String, SaleGoalItemEntity> entityMap = new HashMap<>();
    if (!CollectionUtils.isEmpty(monthTargetEntities)) {
      entityMap = monthTargetEntities.stream().collect(Collectors.toMap(SaleGoalItemEntity::getSaleGoalId,
              a -> a, (k1, k2) -> k1));
    }
    for (String str : saleGoalIds) {
      SaleGoalItemVo vo = null;
      SaleGoalItemEntity entity = entityMap.get(str);
      if (null != entity) {
        vo = new SaleGoalItemVo();
        BeanUtils.copyProperties(entity, vo);
      }
      reMap.put(str, vo);
    }
    return reMap;
  }

  /**
   * 根据销售目标删除明细记录
   * @param goalIds
   */
  @Override
  public void deleteByGoalIds(List<String> goalIds) {
    if(CollectionUtil.listEmpty(goalIds)) {
      return;
    }
    this.saleGoalItemMapper.deleteBatchIds(goalIds);
  }
}
