package com.biz.crm.salegoal.utils;

import com.biz.crm.eunm.dms.SaleGoalEunm;
import com.biz.crm.nebular.dms.salegoal.SaleGoalItemVo;
import com.biz.crm.nebular.dms.salegoal.SaleGoalVo;
import com.biz.crm.nebular.dms.salestarget.SalesMonthTargetVo;
import com.biz.crm.salegoal.entity.SaleGoalItemEntity;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.FieldHandleUtil;
import com.biz.crm.util.ValidateUtils;
import java.math.BigDecimal;
import org.springframework.beans.BeanUtils;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/9/15 16:23
 **/
public class SaleGoalItemUtil {

  /**
   * 为addBatch方法组装对象
   * @param saleGoalItemVo
   * @return
   */
  public static SaleGoalItemEntity packageEntityForAddBatch(SaleGoalItemVo saleGoalItemVo) {
    sumSingleItem(saleGoalItemVo);
    SaleGoalItemEntity entity = CrmBeanUtil.copy(saleGoalItemVo, SaleGoalItemEntity.class);
    return entity;
  }

  /**
   * 组装销售目标明细编辑参数
   * @param saleGoalItemVo
   */
  public static SaleGoalItemEntity packageEntityForUpdate(SaleGoalItemVo saleGoalItemVo) {
    sumSingleItem(saleGoalItemVo);
    SaleGoalItemEntity entity = CrmBeanUtil.copy(saleGoalItemVo, SaleGoalItemEntity.class);
    return entity;
  }

  /**
   * 汇总明细内部数据
   * @param saleGoalItemVo
   */
  public static SaleGoalItemVo sumSingleItem(SaleGoalItemVo saleGoalItemVo) {
    FieldHandleUtil.initDecimalZero(saleGoalItemVo);
    SaleGoalEunm.TaskType taskType = SaleGoalEunm.getTaskTypeByCode(saleGoalItemVo.getTaskType());
    ValidateUtils.validate(taskType, "汇总目标明细时，没有获取到任务类型");
    BigDecimal yearSum = BigDecimal.ZERO;
    switch (taskType) {
      case YEARLY:
        //设置年度汇总
        saleGoalItemVo.setYearlySum(saleGoalItemVo.getYearlyNum());
        break;
      case QUARTER:
        //计算年度汇总
        yearSum = yearSum.add(saleGoalItemVo.getFirstQuarterNum())
                .add(saleGoalItemVo.getSecondQuarterNum())
                .add(saleGoalItemVo.getThirdQuarterNum())
                .add(saleGoalItemVo.getFourthQuarterNum());
        saleGoalItemVo.setYearlySum(yearSum);
        //计算季度汇总
        saleGoalItemVo.setFirstQuarterSum(saleGoalItemVo.getFirstQuarterNum());
        saleGoalItemVo.setSecondQuarterSum(saleGoalItemVo.getSecondQuarterNum());
        saleGoalItemVo.setThirdQuarterSum(saleGoalItemVo.getThirdQuarterNum());
        saleGoalItemVo.setFourthQuarterSum(saleGoalItemVo.getFourthQuarterNum());
        break;
      case MONTHLY:
        //第一季度汇总
        BigDecimal firstQuarterSum = saleGoalItemVo.getJanTargetNum()
                .add(saleGoalItemVo.getFebTargetNum())
                .add(saleGoalItemVo.getMarTargetNum());
        saleGoalItemVo.setFirstQuarterSum(firstQuarterSum);
        //第二季度胡总
        BigDecimal secondQuarterSum = saleGoalItemVo.getAprTargetNum()
                .add(saleGoalItemVo.getMayTargetNum())
                .add(saleGoalItemVo.getJunTargetNum());
        saleGoalItemVo.setSecondQuarterSum(secondQuarterSum);
        //第三季度汇总
        BigDecimal thirdQuarterSum = saleGoalItemVo.getJulTargetNum()
                .add(saleGoalItemVo.getAugTargetNum())
                .add(saleGoalItemVo.getFebTargetNum());
        saleGoalItemVo.setThirdQuarterSum(thirdQuarterSum);
        //第四季度汇总
        BigDecimal fourthQuarterSum = saleGoalItemVo.getOctTargetNum()
                .add(saleGoalItemVo.getDecTargetNum())
                .add(saleGoalItemVo.getNovTargetNum());
        saleGoalItemVo.setFourthQuarterSum(fourthQuarterSum);
        //年度汇总
        yearSum = firstQuarterSum.add(secondQuarterSum)
                .add(thirdQuarterSum).add(fourthQuarterSum);
        saleGoalItemVo.setYearlySum(yearSum);
        break;
      default:
        break;
    }
    return saleGoalItemVo;
  }

  /**
   * 将vo中的目标数字转换成字符串PC端
   * @param vo
   */
  public static void salesTargetToStr(SaleGoalItemVo vo) {
    if (null != vo) {
      if (null != vo.getJanTargetNum()) {
        vo.setJanTargetNumStr(vo.getJanTargetNum().stripTrailingZeros().toPlainString());
      }
      if (null != vo.getFebTargetNum()) {
        vo.setFebTargetNumStr(vo.getFebTargetNum().stripTrailingZeros().toPlainString());
      }
      if (null != vo.getMarTargetNum()) {
        vo.setMarTargetNumStr(vo.getMarTargetNum().stripTrailingZeros().toPlainString());
      }
      if (null != vo.getAprTargetNum()) {
        vo.setAprTargetNumStr(vo.getAprTargetNum().stripTrailingZeros().toPlainString());
      }
      if (null != vo.getMayTargetNum()) {
        vo.setMayTargetNumStr(vo.getMayTargetNum().stripTrailingZeros().toPlainString());
      }
      if (null != vo.getJunTargetNum()) {
        vo.setJunTargetNumStr(vo.getJunTargetNum().stripTrailingZeros().toPlainString());
      }
      if (null != vo.getJulTargetNum()) {
        vo.setJulTargetNumStr(vo.getJulTargetNum().stripTrailingZeros().toPlainString());
      }
      if (null != vo.getAugTargetNum()) {
        vo.setAugTargetNumStr(vo.getAugTargetNum().stripTrailingZeros().toPlainString());
      }
      if (null != vo.getSepTargetNum()) {
        vo.setSepTargetNumStr(vo.getSepTargetNum().stripTrailingZeros().toPlainString());
      }
      if (null != vo.getOctTargetNum()) {
        vo.setOctTargetNumStr(vo.getOctTargetNum().stripTrailingZeros().toPlainString());
      }
      if (null != vo.getNovTargetNum()) {
        vo.setNovTargetNumStr(vo.getNovTargetNum().stripTrailingZeros().toPlainString());
      }
      if (null != vo.getDecTargetNum()) {
        vo.setDecTargetNumStr(vo.getDecTargetNum().stripTrailingZeros().toPlainString());
      }
    }
  }

}
