package com.biz.crm.salesarea.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;



import javax.persistence.Index;


/**
 * @author liufan E-mail:fan.liu@biz-united.com.cn
 * @version 创建时间：2021/2/20
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("dms_sales_area")
@CrmTable(name = "dms_sales_area", indexes = {
        @Index(name = "index_sales_area_code", columnList = "sale_contract_code")
},tableNote = "销售范围")
public class SalesAreaEntity extends CrmExtTenEntity {
    /**
     * 合同编码
     */
    @CrmColumn(name = "sale_contract_code", length = 64)
    private String saleContractCode;
    /**
     * 国家编码
     */
    @CrmColumn(name = "country_cdoe", length = 64)
    private String countryCode;
    /**
     * 国家名称
     */
    @CrmColumn(name = "country", length = 100)
    private String country;
    /**
     * 省编码
     */
    @CrmColumn(name = "province_code", length = 64)
    private String provinceCode;
    /**
     * 城市编码
     */
    @CrmColumn(name = "city_code", length = 64)
    private String cityCode;
    /**
     * 区县编码
     */
    @CrmColumn(name = "district_code", length = 64)
    private String districtCode;
    /**
     * 乡镇编码
     */
    @CrmColumn(name = "village_code", length = 64)
    private String villageCode;
    /**
     * 街道编码
     */
    @CrmColumn(name = "street_code", length = 64)
    private String streetCode;
    /**
     * 省份
     */
    @CrmColumn(name = "province", length = 100)
    private String province;
    /**
     * 城市
     */
    @CrmColumn(name = "city", length = 100)
    private String city;
    /**
     * 区/县
     */
    @CrmColumn(name = "district", length = 100)
    private String district;
    /**
     * 乡镇
     */
    @CrmColumn(name = "village", length = 100)
    private String village;
    /**
     * 街道
     */
    @CrmColumn(name = "street", length = 100)
    private String street;
    /**
     * 是否包含，1：是，0：否
     */
    @CrmColumn(name = "contain_flag")
    private Integer containFlag;
}
