package com.biz.crm.salesarea.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.liabilityforbreach.entity.LiabilityForBreachEntity;
import com.biz.crm.nebular.dms.salesarea.SalesAreaVo;
import com.biz.crm.salesarea.entity.SalesAreaEntity;
import com.biz.crm.salesarea.mapper.SalesAreaMapper;
import com.biz.crm.salesarea.service.SalesAreaService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.ValidateUtils;
import com.google.common.collect.Lists;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * @author liufan E-mail:fan.liu@biz-united.com.cn
 * @version 创建时间：2021/2/20
 */
@Service("salesAreaService")
@ConditionalOnMissingBean(name = "salesAreaServiceImpl")
public class SalesAreaServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<SalesAreaMapper, SalesAreaEntity> implements SalesAreaService {
  @Resource
  private SalesAreaMapper salesAreaMapper;

  /**
   * 新增一条数据
   * 1、入参校验
   * 2、获取参数
   * 3、保存
   * 4、返回结果
   * @param vos
   * @return
   */
  @Override
  @Transactional
  public List<SalesAreaVo> replaceSalesArea(List<SalesAreaVo> vos, String contractCode) {

    //入参校验
    this.validateAdd(vos);
    if(CollectionUtil.listEmpty(vos)) {
      return Lists.newArrayList();
    }
    SalesAreaVo areaVoReq = vos.get(0);
    List<SalesAreaVo> areaVos = Lists.newArrayList();
    if (CollectionUtil.listNotEmpty(areaVoReq.getVoList())) {
      areaVos.addAll(areaVoReq.getVoList());
    }
    areaVos.forEach(vo -> vo.setSaleContractCode(contractCode));
    //获取参数
    List<SalesAreaEntity> entities = CrmBeanUtil.copyList(areaVos, SalesAreaEntity.class);
    //删除之前的数据
    salesAreaMapper.delete(new QueryWrapper<SalesAreaEntity>().eq("sale_contract_code", contractCode));
    //保存
    boolean addResult = this.saveBatch(entities);
//    ValidateUtils.isTrue(addResult, "操作失败");
    areaVoReq.setVoList(CrmBeanUtil.copyList(entities, SalesAreaVo.class));
    return vos;
  }


  /**
   * 根据合同id查询销售区域
   * 1、入参校验
   * 2、获取记录
   * 3、包装vo返回结果
   * @param saleContractCode
   * @return
   */
  @Override
  public SalesAreaVo listSalesArea(String saleContractCode) {
    //校验入参,合同编码不能为空
    ValidateUtils.validate(saleContractCode, "合同id不能为空");
    //进行查询
    List<SalesAreaEntity> entityList = salesAreaMapper.selectList(
            new QueryWrapper<SalesAreaEntity>().eq("sale_contract_code", saleContractCode));
    //包装vo
    List<SalesAreaVo> voList = new ArrayList<>(entityList.size());
    entityList.forEach(entity -> {
      SalesAreaVo vo = CrmBeanUtil.copy(entity, SalesAreaVo.class);
      voList.add(vo);
    });
    SalesAreaVo salesAreaVo = new SalesAreaVo();
    salesAreaVo.setVoList(voList);
    return salesAreaVo;
  }


  /**
   * 校验新增入参
   * @param vos
   */
  private void validateAdd(List<SalesAreaVo> vos) {
    ValidateUtils.isTrue(CollectionUtil.listNotEmpty(vos), "入参不能为空");
  }
}
