package com.biz.crm.salestarget.service;

import com.biz.crm.nebular.dms.salestarget.SalesMonthTargetVo;

import java.util.List;
import java.util.Map;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/9/15 16:10
 **/
public interface SalesMonthTargetService {

    /**
     * 批量保存月份目标
     * @param salesMonthTargetVos
     */
    void addBatch(List<SalesMonthTargetVo> salesMonthTargetVos);

    /**
     * 更新月份目标
     * @param salesMonthTargetVo
     */
    void update(SalesMonthTargetVo salesMonthTargetVo);


    /**
     * 根据销售年目标id查询销售月份目标详情
     * 注意：
     *      该方法是为管理端查询销售年目标提供的子方法，因为年目标有了，肯定会存在月目标，所以该方法不用做验证
     * @param salesTargetId
     * @return
     */
    SalesMonthTargetVo findBySalesTargetId(String salesTargetId);


    /**
     * 根据销售年目标id列表批量查询销售月份目标详情
     * 注意：
     *      该方法是为管理端查询销售年目标提供的子方法，因为年目标有了，肯定会存在月目标，所以该方法不用做验证
     * @param salesTargetIds
     * @return key->销售年目标id value->详情  map.size = salesTargetId.size map永远不为nul
     */
    Map<String,SalesMonthTargetVo> findBySalesTargetIds(List<String> salesTargetIds);
}
