package com.biz.crm.salestarget.service;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.dms.salestarget.SalesTargetVo;

import java.util.ArrayList;
import java.util.List;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/9/15 16:10
 **/
public interface SalesTargetService {

    /**
     * 批量新增
     * @param salesTargetVos
     */
    void addBatch(List<SalesTargetVo> salesTargetVos);

    /**
     * 编辑
     * @param salesTargetVo
     */
    void edit(SalesTargetVo salesTargetVo);

    /**
     * 通过id查询对象
     * @param id
     * @return
     */
    SalesTargetVo findById(String id);

    /**
     * 分页搜索
     * @param salesTargetVo
     * @return
     */
    PageResult<SalesTargetVo> list(SalesTargetVo salesTargetVo);

    /**
     * 根据id批量删除或者恢复
     * @param ids
     */
    void delByIds(ArrayList<String> ids);

    /**
     * 根据查询条件批量删除
     * @param salesTargetVo
     */
    void delByParam(SalesTargetVo salesTargetVo);
}
