package com.biz.crm.salestarget.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.nebular.dms.salestarget.SalesMonthTargetVo;
import com.biz.crm.salestarget.entity.SalesMonthTargetEntity;
import com.biz.crm.salestarget.mapper.SalesMonthTargetMapper;
import com.biz.crm.salestarget.service.SalesMonthTargetService;
import com.biz.crm.salestarget.utils.SalesMonthTargetUtil;
import com.biz.crm.util.ValidateUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/9/15 16:12
 **/
@ConditionalOnMissingBean(name = "salesMonthTargetServiceExpandImpl")
@Service(value = "salesMonthTargetService")
public class SalesMonthTargetServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<SalesMonthTargetMapper, SalesMonthTargetEntity> implements SalesMonthTargetService {

    @Autowired
    private SalesMonthTargetMapper salesMonthTargetMapper;

    @Override
    public void addBatch(List<SalesMonthTargetVo> salesMonthTargetVos) {
        if(CollectionUtils.isEmpty(salesMonthTargetVos)){
            return;
        }
        List<SalesMonthTargetEntity> entities = new ArrayList<>(salesMonthTargetVos.size());
        for(SalesMonthTargetVo vo : salesMonthTargetVos){
            if(vo == null){
                throw new BusinessException("月目标详情必填！");
            }
            entities.add(SalesMonthTargetUtil.packageEntityForAddBatch(vo));
        }
        this.saveBatch(entities);
    }


    /**
     * 1、验证
     * 2、组装更新
     * @param salesMonthTargetVo
     */
    @Override
    public void update(SalesMonthTargetVo salesMonthTargetVo) {
        //1
        ValidateUtils.validate(salesMonthTargetVo.getId(),"请指定要编辑的月销售目标!");
        SalesMonthTargetEntity entity = salesMonthTargetMapper.selectById(salesMonthTargetVo.getId());
        ValidateUtils.validate(entity,"您要编辑的销售目标不存在或者已经被删除!");

        //2
        BeanUtils.copyProperties(salesMonthTargetVo,entity);
        salesMonthTargetMapper.updateById(entity);
    }

    /**
     * @param salesTargetId
     * @return
     */
    @Override
    public SalesMonthTargetVo findBySalesTargetId(String salesTargetId) {
        QueryWrapper<SalesMonthTargetEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("sales_target_id", salesTargetId);
        List<SalesMonthTargetEntity> monthTargetEntities = salesMonthTargetMapper.selectList(wrapper);
        SalesMonthTargetVo vo = new SalesMonthTargetVo();
        BeanUtils.copyProperties(monthTargetEntities.get(0),vo);
        SalesMonthTargetUtil.salesTargetToStr(vo);
        return vo;
    }

    /**
     * 1、验证
     * 2、查询组装返回
     * @param salesTargetIds
     * @return
     */
    @Override
    public Map<String, SalesMonthTargetVo> findBySalesTargetIds(List<String> salesTargetIds) {
        //1
        Map<String, SalesMonthTargetVo> reMap = new HashMap<>();
        if(CollectionUtils.isEmpty(salesTargetIds)){
            return reMap;
        }

        //2
        QueryWrapper<SalesMonthTargetEntity> wrapper = new QueryWrapper<>();
        wrapper.in("sales_target_id", salesTargetIds);
        List<SalesMonthTargetEntity> monthTargetEntities = salesMonthTargetMapper.selectList(wrapper);
        Map<String,SalesMonthTargetEntity> entityMap = new HashMap<>();
        if(!CollectionUtils.isEmpty(monthTargetEntities)){
            entityMap = monthTargetEntities.stream().collect(Collectors.toMap(SalesMonthTargetEntity::getSalesTargetId,
                    a -> a,(k1, k2)->k1));
        }
        for(String str : salesTargetIds){
            SalesMonthTargetVo vo = null;
            SalesMonthTargetEntity entity = entityMap.get(str);
            if(null != entity){
                vo = new SalesMonthTargetVo();
                BeanUtils.copyProperties(entity,vo);
            }
            reMap.put(str,vo);
        }
        return reMap;
    }
}
