package com.biz.crm.salestarget.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.GlobalParam;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.eunm.dms.SalesTargetEunm;
import com.biz.crm.nebular.dms.salestarget.SalesMonthTargetVo;
import com.biz.crm.nebular.dms.salestarget.SalesTargetVo;
import com.biz.crm.salestarget.entity.SalesTargetEntity;
import com.biz.crm.salestarget.mapper.SalesTargetMapper;
import com.biz.crm.salestarget.service.SalesMonthTargetService;
import com.biz.crm.salestarget.service.SalesTargetService;
import com.biz.crm.salestarget.utils.SalesMonthTargetUtil;
import com.biz.crm.salestarget.utils.SalesTargetUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.ValidateUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/9/15 16:11
 **/
@ConditionalOnMissingBean(name = "salesTargetServiceExpandImpl")
@Service(value = "salesTargetService")
public class SalesTargetServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<SalesTargetMapper, SalesTargetEntity> implements SalesTargetService {

    @Resource
    private SalesTargetMapper salesTargetMapper;

    @Resource
    private SalesMonthTargetService salesMonthTargetService;
    @Autowired
    private CrmLogSendUtil crmLogSendUtil;
    /**
     * 1、验证
     * 2、组装
     * 3、分批次保存并且保存月目标
     * @param salesTargetVos
     */
    @Transactional
    @Override
    public void addBatch(List<SalesTargetVo> salesTargetVos) {
        //1
        this.validateForAddBatch(salesTargetVos);

        //2
        Map<String,SalesMonthTargetVo> monthTatgetMap = new HashMap<>(salesTargetVos.size());
        List<SalesTargetEntity> entities = new ArrayList<>(salesTargetVos.size());
        for(SalesTargetVo vo : salesTargetVos){
            SalesMonthTargetVo monthTarget = vo.getSalesMonthTargetVo();
            if(null == monthTarget){
                throw new BusinessException("月份目标必填!");
            }
            SalesTargetEntity entity = SalesTargetUtil.packageEntityForAdd(vo);
            monthTarget.setSalesTargetId(entity.getId());
            entities.add(entity);
            monthTatgetMap.put(entity.getId(),monthTarget);
        }

        //3
        List<SalesTargetEntity> currentEntities = new ArrayList<>();
        List<SalesMonthTargetVo> currentMonthTargets = new ArrayList<>(salesTargetVos.size());
        int entityI = 0;
        for(SalesTargetEntity entity : entities){
            entityI ++;
            currentEntities.add(entity);
            currentMonthTargets.add(monthTatgetMap.get(entity.getId()));
            if(currentEntities.size() == 500 || entityI == entities.size()){
                this.saveBatch(currentEntities);
                salesMonthTargetService.addBatch(currentMonthTargets);
                currentEntities.clear();
                currentMonthTargets.clear();
            }
        }
        Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        for(SalesTargetEntity entity : entities){
            SalesTargetVo copy = CrmBeanUtil.copy(entity, SalesTargetVo.class);
            crmLogSendUtil.sendForAdd(menuCodeObj.toString(),copy.getId(),copy.getId(),copy);
        }

        //
    }

    /**
     * AddBatch的验证方法
     * 1、验证参数
     * 2、验证是否数据库存在
     * @param salesTargetVos
     */
    private void validateForAddBatch(List<SalesTargetVo> salesTargetVos){
        //1
        SalesTargetUtil.validateParamForAddBatch(salesTargetVos);

        //2
        List<String> params = new ArrayList<>(salesTargetVos.size());
        for(SalesTargetVo vo : salesTargetVos){
            if(vo.getType().intValue() == SalesTargetEunm.type.GOODS.getCode().intValue()){
                params.add(new StringBuilder(vo.getCusCode()).append(",").append(vo.getGoodsCode()).append(",").append(vo.getTargetYear()).toString());
            }else if(vo.getType().intValue() == SalesTargetEunm.type.PRODUCTLQVEL.getCode().intValue()){
                params.add(new StringBuilder(vo.getCusCode()).append(",").append(vo.getProductLevelCode()).append(",").append(vo.getTargetYear()).toString());
            }else {
                params.add(new StringBuilder(vo.getCusCode()).append(vo.getTargetYear().toString()).toString());
            }
        }
        //避免大数据量导入，所以分批次查询
        List<String> currentParam = new ArrayList<>();
        List<SalesTargetEntity> exsits = new ArrayList<>();
        int i = 0;
        Integer type = salesTargetVos.get(0).getType();
        for(String param : params){
            i ++;
            currentParam.add(param);
            if(currentParam.size() == 500 || i == params.size()){
                QueryWrapper<SalesTargetEntity> wrapper = new QueryWrapper<>();
                wrapper.in("only_key", currentParam);
                List<SalesTargetEntity> entities = salesTargetMapper.selectList(wrapper);
                if(!CollectionUtils.isEmpty(entities)){
                    exsits.addAll(entities);
                }
                currentParam.clear();
            }
        }
        if(!CollectionUtils.isEmpty(exsits)){
            StringBuilder stb = new StringBuilder();
            for(SalesTargetEntity entity : exsits){
                if(type.intValue() == SalesTargetEunm.type.GOODS.getCode().intValue()){
                    stb.append(entity.getCusName()).append(",").append(entity.getGoodsName()).append("-").append(entity.getTargetYear()).append(";");
                }else if(type.intValue() == SalesTargetEunm.type.PRODUCTLQVEL.getCode().intValue()){
                    stb.append(entity.getCusName()).append(",").append(entity.getProductLevelName()).append("-").append(entity.getTargetYear()).append(";");
                }else {
                    stb.append(entity.getCusName()).append(",").append(entity.getTargetYear()).append(";");
                }
            }
            StringBuilder msgPre = new StringBuilder("销量目标已经存在,年份为：");
            if(type.intValue() != SalesTargetEunm.type.ROUTINE.getCode().intValue()){
                msgPre = new StringBuilder("销量目标已经存在,客户、产品/产品层级和年份为: ");
            }
            throw new BusinessException(msgPre.append(stb).toString());
        }
    }

    /**
     * 1、验证
     * 2、更新总价
     * 3、更新月目标详情
     * @param salesTargetVo
     */
    @Transactional
    @Override
    public void edit(SalesTargetVo salesTargetVo) {
        //1
        ValidateUtils.validate(salesTargetVo.getId(),"请指定要编辑的销售目标!");
        SalesTargetEntity entity = salesTargetMapper.selectById(salesTargetVo.getId());
        ValidateUtils.validate(entity,"您要编辑的销售目标不存在或者已经被删除!");
        SalesTargetVo oldObject = findById(salesTargetVo.getId());
        //2
        entity.setTargetNum(SalesMonthTargetUtil.countTargetNum(salesTargetVo.getSalesMonthTargetVo()));
        entity.setName(salesTargetVo.getName());
        salesTargetMapper.updateById(entity);

        //3
        salesMonthTargetService.update(salesTargetVo.getSalesMonthTargetVo());
        SalesTargetVo newObject = findById(salesTargetVo.getId());
        Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), salesTargetVo.getId(),salesTargetVo.getId(),oldObject,newObject);

    }

    /**
     * 1、查询主干信息
     * 2、查询月份详情
     * @param id
     * @return
     */
    @CrmDictMethod
    @Override
    public SalesTargetVo findById(String id) {
        SalesTargetVo vo = null;
        //1
        ValidateUtils.validate(id,"请指定需要查询的销售目标！");
        SalesTargetEntity entity = salesTargetMapper.selectById(id);
        if(null == entity){
            return vo;
        }
        vo = new SalesTargetVo();
        BeanUtils.copyProperties(entity,vo);
        vo.setTargetNumStr(vo.getTargetNum().stripTrailingZeros().toPlainString());

        //2
        vo.setSalesMonthTargetVo(salesMonthTargetService.findBySalesTargetId(vo.getId()));

        return vo;
    }

    @CrmDictMethod
    @Override
    public PageResult<SalesTargetVo> list(SalesTargetVo salesTargetVo) {
        QueryWrapper<SalesTargetVo> wrapper = Wrappers.<SalesTargetVo>query()
                .like(!StringUtils.isEmpty(salesTargetVo.getCusName()), "cus_name", salesTargetVo.getCusName())
                .like(!StringUtils.isEmpty(salesTargetVo.getCusCode()), "cus_code", salesTargetVo.getCusCode())
                .like(!StringUtils.isEmpty(salesTargetVo.getCusOrgName()), "cus_org_name", salesTargetVo.getCusOrgName())
                .like(!StringUtils.isEmpty(salesTargetVo.getCusOrgCode()), "cus_org_code", salesTargetVo.getCusOrgCode())
                .like(!StringUtils.isEmpty(salesTargetVo.getCusChannelName()), "cus_channel_name", salesTargetVo.getCusChannelName())
                .eq(!StringUtils.isEmpty(salesTargetVo.getCusChannelCode()), "cus_channel_code", salesTargetVo.getCusChannelCode())
                .eq(null != salesTargetVo.getType(), "type", salesTargetVo.getType())
                .eq(null != salesTargetVo.getTargetYear(), "target_year", salesTargetVo.getTargetYear())
                .eq(!StringUtils.isEmpty(salesTargetVo.getName()), "name", salesTargetVo.getName())
                .like(!StringUtils.isEmpty(salesTargetVo.getGoodsName()), "goods_name", salesTargetVo.getGoodsName())
                .eq(!StringUtils.isEmpty(salesTargetVo.getGoodsCode()), "goods_code", salesTargetVo.getGoodsCode())
                .like(!StringUtils.isEmpty(salesTargetVo.getProductLevelName()), "product_level_name", salesTargetVo.getProductLevelName())
                .eq(!StringUtils.isEmpty(salesTargetVo.getProductLevelCode()), "product_level_code", salesTargetVo.getProductLevelCode())
                .in(!CollectionUtil.listEmpty(salesTargetVo.getOfficeCodes()), "ext33", salesTargetVo.getOfficeCodes())
                .orderByDesc("create_date", "create_date_second");
        Page<SalesTargetVo> page = PageUtil.buildPage(salesTargetVo.getPageNum(), salesTargetVo.getPageSize());
        List<SalesTargetVo> list = salesTargetMapper.list(page,wrapper);
        if(!CollectionUtils.isEmpty(list)){
            Map<String, SalesMonthTargetVo> detailMap = salesMonthTargetService.findBySalesTargetIds(list.stream().map(SalesTargetVo :: getId).collect(Collectors.toList()));
            for(SalesTargetVo vo : list){
                vo.setTargetNumStr(vo.getTargetNum().stripTrailingZeros().toPlainString());
                vo.setSalesMonthTargetVo(detailMap.get(vo.getId()));
            }
        }
        return PageResult.<SalesTargetVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    @Transactional
    @Override
    public void delByIds(ArrayList<String> ids) {
        if(CollectionUtils.isEmpty(ids)){
            return;
        }
        Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        List<SalesTargetVo> vos = this.findByIds(ids);
        ValidateUtils.validate(vos,"请指定需要查询的销售目标！");
        salesTargetMapper.deleteBatchIds(ids);
        vos.forEach(vo -> {
            crmLogSendUtil.sendForDel(menuCodeObj.toString(),vo.getId(),vo.getId(),vo);
        });
    }

    @Transactional
    @Override
    public void delByParam(SalesTargetVo salesTargetVo) {
        if(null == salesTargetVo){
            throw new BusinessException("请指定查询条件!");
        }
        QueryWrapper<SalesTargetEntity> wrapper = Wrappers.<SalesTargetEntity>query()
                .like(!StringUtils.isEmpty(salesTargetVo.getCusName()), "cus_name", salesTargetVo.getCusName())
                .eq(!StringUtils.isEmpty(salesTargetVo.getCusCode()), "cus_code", salesTargetVo.getCusCode())
                .like(!StringUtils.isEmpty(salesTargetVo.getCusOrgName()), "cus_org_name", salesTargetVo.getCusOrgName())
                .eq(!StringUtils.isEmpty(salesTargetVo.getCusOrgCode()), "cus_org_code", salesTargetVo.getCusOrgCode())
                .like(!StringUtils.isEmpty(salesTargetVo.getCusChannelName()), "cus_channel_name", salesTargetVo.getCusChannelName())
                .eq(!StringUtils.isEmpty(salesTargetVo.getCusChannelCode()), "cus_channel_code", salesTargetVo.getCusChannelCode())
                .eq(null != salesTargetVo.getType(), "type", salesTargetVo.getType())
                .eq(null != salesTargetVo.getTargetYear(), "target_year", salesTargetVo.getTargetYear())
                .like(!StringUtils.isEmpty(salesTargetVo.getGoodsName()), "goods_name", salesTargetVo.getGoodsName())
                .eq(!StringUtils.isEmpty(salesTargetVo.getGoodsCode()), "goods_code", salesTargetVo.getGoodsCode())
                .like(!StringUtils.isEmpty(salesTargetVo.getProductLevelName()), "product_level_name", salesTargetVo.getProductLevelName())
                .eq(!StringUtils.isEmpty(salesTargetVo.getProductLevelCode()), "product_level_code", salesTargetVo.getProductLevelCode());
        List<SalesTargetEntity> entities = salesTargetMapper.selectList(wrapper);
        List<String> ids = entities.stream().map(entity -> entity.getId()).collect(Collectors.toList());
        List<SalesTargetVo> vos = this.findByIds(ids);
        Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        salesTargetMapper.delete(wrapper);
        vos.forEach(vo -> crmLogSendUtil.sendForDel(menuCodeObj.toString(),vo.getId(),vo.getId(),vo));
    }

    private List<SalesTargetVo> findByIds(List<String> ids) {
        List<SalesTargetVo> vos = null;
        ValidateUtils.validate(ids,"请指定需要查询的销售目标！");
        List<SalesTargetEntity> entities = this.lambdaQuery()
                .in(SalesTargetEntity::getId, ids)
                .list();
        if(null == entities){
            return vos;
        }
        vos = CrmBeanUtil.copyList(entities,SalesTargetVo.class);
        Map<String, SalesMonthTargetVo> detailMap = salesMonthTargetService.findBySalesTargetIds(ids);
        for(SalesTargetVo vo : vos){
            vo.setTargetNumStr(vo.getTargetNum().stripTrailingZeros().toPlainString());
            vo.setSalesMonthTargetVo(detailMap.get(vo.getId()));
        }
        return vos;
    }
}
