package com.biz.crm.util;

import com.biz.crm.base.BusinessException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * @Author: chenrong
 * @Date: 2020/12/3 15:30
 */
public class TimeUtil {
  
  public static final String YYYY_MM_DD = "yyyy-MM-dd";
  public static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
  
  public static String getMonthStart(Date date, String format) {
    Date d = date;
    if(d == null) {
      d = new Date();
    }
    Calendar cal = Calendar.getInstance();
    cal.setTime(d);
    cal.set(Calendar.DAY_OF_MONTH, 1);
    cal.set(Calendar.HOUR_OF_DAY, 0);
    cal.set(Calendar.MINUTE, 0);
    cal.set(Calendar.SECOND, 0);
    cal.set(Calendar.MILLISECOND, 0);
    return new SimpleDateFormat(format).format(cal.getTime());
  }

  public static String getMonthEnd(Date date, String format) {
    Date d = date;
    if(d == null) {
      d = new Date();
    }
    try {
      Calendar calendar = Calendar.getInstance();
      calendar.setTime(d);
      calendar.add(Calendar.MONTH, 1);
      calendar.set(Calendar.DAY_OF_MONTH, 0);
      calendar.set(Calendar.HOUR_OF_DAY, 23);
      calendar.set(Calendar.MINUTE, 59);
      calendar.set(Calendar.SECOND, 59);
      calendar.set(Calendar.MILLISECOND, 999);
      return new SimpleDateFormat(format).format(calendar.getTime());
    } catch (Exception e) {
      throw new BusinessException("获取月末时间异常", e);
    }
  }

  /**
   * 判断a时间大于b时间
   * @param big
   * @param small
   * @return
   */
  public static boolean bigThan(Date big, Date small) {
    if(big == null) {
      return false;
    }
    if(small == null) {
      return true;
    }
    return big.getTime() > small.getTime();
  }
}
