/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.companyinformation.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.companyinformation.entity.CompanyInformationAreaEntity;
import com.biz.crm.companyinformation.entity.CompanyInformationEntity;
import com.biz.crm.companyinformation.mapper.CompanyInformationAreaMapper;
import com.biz.crm.companyinformation.service.CompanyInformationAreaService;
import com.biz.crm.nebular.dms.companyinformation.CompanyInformationAreaVo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@ConditionalOnMissingBean(name={"companyInformationAreaServiceExpand"})
@Service(value="companyInformationAreaService")
public class CompanyInformationAreaServiceImpl
extends ServiceImpl<CompanyInformationAreaMapper, CompanyInformationAreaEntity>
implements CompanyInformationAreaService {
    @Autowired
    private CompanyInformationAreaMapper companyInformationAreaMapper;

    @Override
    @Transactional
    public void replace(final CompanyInformationEntity companyInformationEntity, List<CompanyInformationAreaVo> areaVos) {
        this.removeByMap(new HashMap<String, Object>(){
            {
                this.put("information_id", companyInformationEntity.getId());
            }
        });
        ArrayList<CompanyInformationAreaEntity> entities = new ArrayList<CompanyInformationAreaEntity>();
        if (CollectionUtils.isEmpty(areaVos)) {
            CompanyInformationAreaEntity entity = new CompanyInformationAreaEntity();
            entity.setOrgCode("000");
            entity.setOrgName("\u5168\u90e8");
            entity.setInformationId(companyInformationEntity.getId());
            entities.add(entity);
        } else {
            for (CompanyInformationAreaVo vo : areaVos) {
                CompanyInformationAreaEntity entity = new CompanyInformationAreaEntity();
                BeanUtils.copyProperties((Object)vo, (Object)((Object)entity));
                entity.setInformationId(companyInformationEntity.getId());
                entities.add(entity);
            }
        }
        this.saveBatch(entities);
    }

    @Override
    public List<CompanyInformationAreaVo> findByInformationId(String informationId) {
        if (StringUtils.isEmpty((Object)informationId)) {
            return new ArrayList<CompanyInformationAreaVo>();
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"information_id", (Object)informationId);
        List areaEntities = this.companyInformationAreaMapper.selectList((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)areaEntities)) {
            return new ArrayList<CompanyInformationAreaVo>();
        }
        ArrayList<CompanyInformationAreaVo> reList = new ArrayList<CompanyInformationAreaVo>(areaEntities.size());
        for (CompanyInformationAreaEntity entity : areaEntities) {
            CompanyInformationAreaVo vo = new CompanyInformationAreaVo();
            BeanUtils.copyProperties((Object)((Object)entity), (Object)vo);
            reList.add(vo);
        }
        return reList;
    }

    @Override
    public void delByInformationIds(List<String> informationIds) {
        if (CollectionUtils.isEmpty(informationIds)) {
            throw new BusinessException("\u516c\u53f8\u8d44\u6599id\u4e3a\u7a7a");
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"information_id", informationIds);
        this.companyInformationAreaMapper.delete((Wrapper)wrapper);
    }
}

