/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.notice.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.annotation.Klock;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.dms.notice.ListReq;
import com.biz.crm.nebular.dms.notice.ListRes;
import com.biz.crm.nebular.dms.notice.NoticeFileVo;
import com.biz.crm.nebular.dms.notice.NoticeVo;
import com.biz.crm.notice.entity.NoticeEntity;
import com.biz.crm.notice.mapper.NoticeMapper;
import com.biz.crm.notice.service.NoticeAreaService;
import com.biz.crm.notice.service.NoticeFileService;
import com.biz.crm.notice.service.NoticeService;
import com.biz.crm.notice.utils.NoticeUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.ValidateUtils;
import com.bizunited.platform.common.vo.UuidVo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@ConditionalOnMissingBean(name={"noticeServiceExpand"})
@Service(value="noticeService")
public class NoticeServiceImpl
extends ServiceImpl<NoticeMapper, NoticeEntity>
implements NoticeService {
    @Autowired
    private NoticeMapper noticeMapper;
    @Resource
    private NoticeFileService noticeFileService;
    @Resource
    private NoticeAreaService noticeAreaService;

    @Override
    @Transactional
    public void add(NoticeVo noticeVo) {
        ValidateUtils.validate((Object)noticeVo.getTitle(), (String)"\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a!");
        ValidateUtils.validate((Object)noticeVo.getType(), (String)"\u8bf7\u6307\u5b9a\u7c7b\u578b!");
        ValidateUtils.validate((Object)noticeVo.getStartTime(), (String)"\u8bf7\u6307\u5b9a\u6709\u6548\u65f6\u95f4\u6bb5!");
        ValidateUtils.validate((Object)noticeVo.getStartTime(), (String)"\u8bf7\u6307\u5b9a\u6709\u6548\u65f6\u95f4\u6bb5!");
        NoticeEntity entity = new NoticeEntity();
        BeanUtils.copyProperties((Object)noticeVo, (Object)((Object)entity));
        entity.setVisitNum(0);
        this.noticeMapper.insert((Object)entity);
        this.noticeFileService.replace(entity, noticeVo.getFiles());
        this.noticeAreaService.replace(entity, noticeVo.getAreaes());
    }

    @Override
    @Transactional
    public void edit(NoticeVo noticeVo) {
        ValidateUtils.validate((Object)noticeVo.getId(), (String)"\u8bf7\u6307\u5b9a\u8981\u7f16\u8f91\u7684\u8d44\u6599!");
        ValidateUtils.validate((Object)noticeVo.getTitle(), (String)"\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a!");
        ValidateUtils.validate((Object)noticeVo.getType(), (String)"\u8bf7\u6307\u5b9a\u7c7b\u578b!");
        ValidateUtils.validate((Object)noticeVo.getStartTime(), (String)"\u8bf7\u6307\u5b9a\u6709\u6548\u65f6\u95f4\u6bb5!");
        ValidateUtils.validate((Object)noticeVo.getStartTime(), (String)"\u8bf7\u6307\u5b9a\u6709\u6548\u65f6\u95f4\u6bb5!");
        NoticeEntity entity = (NoticeEntity)((Object)this.noticeMapper.selectById((Serializable)((Object)noticeVo.getId())));
        ValidateUtils.validate((Object)((Object)entity), (String)"\u60a8\u8981\u7f16\u8f91\u7684\u8d44\u6599\u4e0d\u5b58\u5728\u6216\u8005\u5df2\u7ecf\u88ab\u5220\u9664!");
        BeanUtils.copyProperties((Object)noticeVo, (Object)((Object)entity));
        this.noticeMapper.updateById((Object)entity);
        this.noticeFileService.replace(entity, noticeVo.getFiles());
        this.noticeAreaService.replace(entity, noticeVo.getAreaes());
    }

    @Override
    public NoticeVo findById(String id) {
        NoticeVo vo = null;
        ValidateUtils.validate((Object)id, (String)"\u8bf7\u6307\u5b9a\u9700\u8981\u67e5\u8be2\u7684\u8d44\u6599\uff01");
        NoticeEntity entity = (NoticeEntity)((Object)this.noticeMapper.selectById((Serializable)((Object)id)));
        if (null == entity) {
            return vo;
        }
        vo = new NoticeVo();
        BeanUtils.copyProperties((Object)((Object)entity), (Object)vo);
        vo.setFiles(this.noticeFileService.findByNoticeId(id));
        vo.setAreaes(this.noticeAreaService.findByNoticeId(id));
        vo.setNoticeState(Integer.valueOf(NoticeUtil.transState(vo.getStartTime(), vo.getEndTime())));
        return vo;
    }

    @Override
    public NoticeVo findDetailsByFormInstanceId(String formInstanceId) {
        NoticeVo vo = null;
        ValidateUtils.validate((Object)formInstanceId, (String)"\u8bf7\u6307\u5b9a\u9700\u8981\u67e5\u8be2\u7684\u8d44\u6599\uff01");
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"form_instance_id", (Object)formInstanceId);
        List entities = this.noticeMapper.selectList((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)entities)) {
            return vo;
        }
        NoticeEntity entity = (NoticeEntity)((Object)entities.get(0));
        vo = new NoticeVo();
        BeanUtils.copyProperties((Object)((Object)entity), (Object)vo);
        vo.setFiles(this.noticeFileService.findByNoticeId(vo.getId()));
        vo.setAreaes(this.noticeAreaService.findByNoticeId(vo.getId()));
        vo.setNoticeState(Integer.valueOf(NoticeUtil.transState(vo.getStartTime(), vo.getEndTime())));
        return vo;
    }

    @Override
    public PageResult<NoticeVo> list(NoticeVo noticeVo) {
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().like(!StringUtils.isEmpty((Object)noticeVo.getTitle()), (Object)"title", (Object)noticeVo.getTitle())).eq(null != noticeVo.getType(), (Object)"type", (Object)noticeVo.getType())).eq(!StringUtils.isEmpty((Object)noticeVo.getPublishOrgCode()), (Object)"publish_org_code", (Object)noticeVo.getPublishOrgCode())).orderByDesc((Object[])new String[]{"create_date", "create_date_second"});
        Page page = new Page((long)noticeVo.getPageNum().intValue(), (long)noticeVo.getPageSize().intValue());
        List<NoticeVo> list = this.noticeMapper.list(page, (QueryWrapper<NoticeVo>)wrapper);
        if (!CollectionUtils.isEmpty(list)) {
            for (NoticeVo vo : list) {
                vo.setNoticeState(Integer.valueOf(NoticeUtil.transState(vo.getStartTime(), vo.getEndTime())));
            }
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<ListRes> listByUser(ListReq listReq) {
        ValidateUtils.validate((Object)listReq.getOrgCode(), (String)"\u5f53\u524d\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b8c\u5584\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!");
        Page page = new Page((long)listReq.getPageNum().intValue(), (long)listReq.getPageSize().intValue());
        ArrayList<String> orgCodes = new ArrayList<String>();
        orgCodes.add("000");
        orgCodes.add(listReq.getOrgCode());
        List<ListRes> list = this.noticeMapper.listByUser(page, listReq, orgCodes, DateUtil.getDate((String)"yyyy-MM-dd"));
        if (!CollectionUtils.isEmpty(list)) {
            for (ListRes listRes : list) {
                listRes.setNoticeState(Integer.valueOf(NoticeUtil.transState(listRes.getStartTime(), listRes.getEndTime())));
                if (StringUtils.isEmpty((Object)listRes.getNoticeLogId())) {
                    listRes.setMsgState(Integer.valueOf(1));
                    continue;
                }
                listRes.setMsgState(Integer.valueOf(0));
            }
            Map<String, List<NoticeFileVo>> fileMap = this.noticeFileService.findByNoticeIds(list.stream().map(UuidVo::getId).collect(Collectors.toList()));
            for (NoticeVo noticeVo : list) {
                noticeVo.setFiles(fileMap.get(noticeVo.getId()));
            }
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @Transactional
    public void delByIds(ArrayList<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        this.noticeMapper.deleteBatchIds(ids);
        this.noticeFileService.delByNoticeIds(ids);
        this.noticeAreaService.delByNoticeIds(ids);
    }

    @Override
    @Transactional
    public void delByParam(NoticeVo noticeVo) {
        if (null == noticeVo) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u67e5\u8be2\u6761\u4ef6!");
        }
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().like(!StringUtils.isEmpty((Object)noticeVo.getTitle()), (Object)"title", (Object)noticeVo.getTitle())).eq(null != noticeVo.getType(), (Object)"type", (Object)noticeVo.getType())).eq(!StringUtils.isEmpty((Object)noticeVo.getPublishOrgCode()), (Object)"publish_org_code", (Object)noticeVo.getPublishOrgCode());
        List entities = this.noticeMapper.selectList((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)entities)) {
            return;
        }
        List<String> ids = entities.stream().map(BaseIdEntity::getId).collect(Collectors.toList());
        this.noticeMapper.delete((Wrapper)wrapper);
        this.noticeFileService.delByNoticeIds(ids);
        this.noticeAreaService.delByNoticeIds(ids);
    }

    @Override
    @Klock(keys={"NOTICELOGLOCK", "#noticeId"}, waitTime=10L, leaseTime=5L)
    @Transactional
    public void updateVisitNum(String noticeId) {
        NoticeEntity entity = (NoticeEntity)((Object)this.noticeMapper.selectById((Serializable)((Object)noticeId)));
        ValidateUtils.validate((Object)((Object)entity), (String)"\u8be5\u516c\u544a\u5df2\u88ab\u5220\u9664!");
        entity.setVisitNum(entity.getVisitNum() + 1);
        this.noticeMapper.updateById((Object)entity);
    }
}

