/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.promotion.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyEditReqVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyEditVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyScopeEditVo;
import com.biz.crm.promotion.entity.PromotionPolicyScopeEntity;
import com.biz.crm.promotion.mapper.PromotionPolicyScopeMapper;
import com.biz.crm.promotion.service.PromotionPolicyScopeService;
import com.biz.crm.util.CommonConstant;
import com.biz.crm.util.CrmBeanUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Transactional
@ConditionalOnMissingBean(name={"promotionPolicyScopeServiceExpand"})
@Service(value="promotionPolicyScopeService")
public class PromotionPolicyScopeServiceImpl
extends ServiceImpl<PromotionPolicyScopeMapper, PromotionPolicyScopeEntity>
implements PromotionPolicyScopeService {
    @Resource
    private PromotionPolicyScopeMapper promotionPolicyScopeMapper;

    @Override
    public void refreshScope(PromotionPolicyEditReqVo editVo) {
        if (StringUtils.isNotBlank((CharSequence)editVo.getId())) {
            this.doDelByPromotionPolicyIdOrCode(Lists.newArrayList((Object[])new String[]{editVo.getId()}), null);
        }
        List tempEditVos = editVo.takeAllScopes();
        ArrayList editVos = Lists.newArrayList();
        if (CollectionUtils.isEmpty((Collection)tempEditVos)) {
            return;
        }
        HashSet keys = Sets.newHashSet();
        for (PromotionPolicyScopeEditVo temp : tempEditVos) {
            String key = temp.getPromotionPolicyId() + temp.getScopeCode() + temp.getScopeType() + temp.getContainable();
            if (keys.contains(key)) continue;
            temp.setId(null);
            temp.setPromotionPolicyCode(editVo.getPromotionPolicyCode());
            temp.setPromotionPolicyId(editVo.getId());
            temp.setPromotionPolicyName(editVo.getPromotionPolicyName());
            editVos.add(temp);
            keys.add(key);
        }
        this.saveBatch(CrmBeanUtil.copyList((List)editVos, PromotionPolicyScopeEntity.class));
    }

    @Override
    public void loadListForEditPromotionPolicy(PromotionPolicyEditVo editVo) {
        List<PromotionPolicyScopeEntity> channelY = null;
        List<PromotionPolicyScopeEntity> channelN = null;
        List<PromotionPolicyScopeEntity> custY = null;
        List<PromotionPolicyScopeEntity> custN = null;
        List<PromotionPolicyScopeEntity> orgY = null;
        List<PromotionPolicyScopeEntity> orgN = null;
        if (StringUtils.isNotBlank((CharSequence)editVo.getId())) {
            QueryWrapper wrapper = Wrappers.query();
            wrapper.in((Object)"promotion_policy_id", new Object[]{editVo.getId()});
            Map<String, List<PromotionPolicyScopeEntity>> groupByScopeType = this.promotionPolicyScopeMapper.selectList((Wrapper)wrapper).stream().collect(Collectors.groupingBy(v -> v.getScopeType() + v.getContainable()));
            channelY = groupByScopeType.get(CommonConstant.DMS.PromotionPolicyScopeType.CHANNEL.getItemCode() + CommonConstant.GLOBAL.YesOrNo.Y.getItemCode());
            channelN = groupByScopeType.get(CommonConstant.DMS.PromotionPolicyScopeType.CHANNEL.getItemCode() + CommonConstant.GLOBAL.YesOrNo.N.getItemCode());
            custY = groupByScopeType.get(CommonConstant.DMS.PromotionPolicyScopeType.CUST.getItemCode() + CommonConstant.GLOBAL.YesOrNo.Y.getItemCode());
            custN = groupByScopeType.get(CommonConstant.DMS.PromotionPolicyScopeType.CUST.getItemCode() + CommonConstant.GLOBAL.YesOrNo.N.getItemCode());
            orgY = groupByScopeType.get(CommonConstant.DMS.PromotionPolicyScopeType.ORG.getItemCode() + CommonConstant.GLOBAL.YesOrNo.Y.getItemCode());
            orgN = groupByScopeType.get(CommonConstant.DMS.PromotionPolicyScopeType.ORG.getItemCode() + CommonConstant.GLOBAL.YesOrNo.N.getItemCode());
        }
        PromotionPolicyEditReqVo.PromotionPolicyScopeGroup scopesAsOrg = new PromotionPolicyEditReqVo.PromotionPolicyScopeGroup();
        scopesAsOrg.setContainN(CrmBeanUtil.copyList(orgN, PromotionPolicyScopeEditVo.class));
        scopesAsOrg.setContainY(CrmBeanUtil.copyList(orgY, PromotionPolicyScopeEditVo.class));
        PromotionPolicyEditReqVo.PromotionPolicyScopeGroup scopesAsChannel = new PromotionPolicyEditReqVo.PromotionPolicyScopeGroup();
        scopesAsChannel.setContainN(CrmBeanUtil.copyList(channelN, PromotionPolicyScopeEditVo.class));
        scopesAsChannel.setContainY(CrmBeanUtil.copyList(channelY, PromotionPolicyScopeEditVo.class));
        PromotionPolicyEditReqVo.PromotionPolicyScopeGroup scopesAsCust = new PromotionPolicyEditReqVo.PromotionPolicyScopeGroup();
        scopesAsCust.setContainN(CrmBeanUtil.copyList(custN, PromotionPolicyScopeEditVo.class));
        scopesAsCust.setContainY(CrmBeanUtil.copyList(custY, PromotionPolicyScopeEditVo.class));
        PromotionPolicyEditReqVo.PromotionPolicyScope promotionPolicyScope = new PromotionPolicyEditReqVo.PromotionPolicyScope();
        promotionPolicyScope.setScopesAsChannel(scopesAsChannel);
        promotionPolicyScope.setScopesAsCust(scopesAsCust);
        promotionPolicyScope.setScopesAsOrg(scopesAsOrg);
        editVo.setPromotionPolicyScope(promotionPolicyScope);
    }

    @Override
    public void delByPromotionPolicyIdOrCode(List<String> promotionPolicyId, List<String> promotionPolicyCode) {
        this.doDelByPromotionPolicyIdOrCode(promotionPolicyId, promotionPolicyCode);
    }

    @Override
    public Set<String> selectPromotionPolicyIdByScopeCode(String custCode, String orgCode, String channelCode, CommonConstant.DictItem containableYesOrNo) {
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{custCode, orgCode, channelCode})) {
            return Sets.newHashSet();
        }
        String containable = null == containableYesOrNo ? CommonConstant.GLOBAL.YesOrNo.Y.getItemCode() : containableYesOrNo.getItemCode();
        return Sets.newHashSet(this.promotionPolicyScopeMapper.selectPromotionPolicyIdByScopeCode(custCode, orgCode, channelCode, containable));
    }

    private void doDelByPromotionPolicyIdOrCode(List<String> promotionPolicyId, List<String> promotionPolicyCode) {
        QueryWrapper wrapper = Wrappers.query();
        if (!CollectionUtils.isEmpty(promotionPolicyId)) {
            wrapper.in((Object)"promotion_policy_id", promotionPolicyId);
        } else if (!CollectionUtils.isEmpty(promotionPolicyCode)) {
            wrapper.in((Object)"promotion_policy_code", promotionPolicyCode);
        } else {
            return;
        }
        this.promotionPolicyScopeMapper.delete((Wrapper)wrapper);
    }
}

