/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.promotion.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.common.ShellResult;
import com.biz.crm.common.param.BaseGroovyShellParam;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.nebular.dms.promotion.BasePromotionPolicyCalculateShellParam;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyConfigInfo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyEditReqVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyEditVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyInfoVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyQueryVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyRuleVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyVo;
import com.biz.crm.nebular.dms.promotion.PromotionRuleVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.promotion.entity.PromotionPolicyEntity;
import com.biz.crm.promotion.entity.PromotionPolicyProductEntity;
import com.biz.crm.promotion.entity.PromotionPolicyRuleEntity;
import com.biz.crm.promotion.entity.PromotionRuleEntity;
import com.biz.crm.promotion.mapper.PromotionPolicyMapper;
import com.biz.crm.promotion.service.PromotionPolicyProductService;
import com.biz.crm.promotion.service.PromotionPolicyRuleService;
import com.biz.crm.promotion.service.PromotionPolicyScopeService;
import com.biz.crm.promotion.service.PromotionPolicyService;
import com.biz.crm.promotion.service.PromotionRuleService;
import com.biz.crm.rule.utils.GroovyShellUtil;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CommonConstant;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.Result;
import com.bizunited.platform.common.vo.UuidVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Transactional
@ConditionalOnMissingBean(name={"promotionPolicyServiceExpand"})
@Service(value="promotionPolicyService")
public class PromotionPolicyServiceImpl
extends ServiceImpl<PromotionPolicyMapper, PromotionPolicyEntity>
implements PromotionPolicyService {
    @Resource
    private PromotionPolicyMapper promotionPolicyMapper;
    @Resource
    private PromotionPolicyRuleService promotionPolicyRuleService;
    @Resource
    private PromotionRuleService promotionRuleService;
    @Resource
    private PromotionPolicyScopeService promotionPolicyScopeService;
    @Resource
    private PromotionPolicyProductService promotionPolicyProductService;
    @Resource
    private MdmCustomerMsgFeign mdmCustomerMsgFeign;

    @Override
    public void addOrUpdate(PromotionPolicyEditReqVo vo) {
        this.checkParams(vo);
        if (StringUtils.isBlank((CharSequence)vo.getId())) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"promotion_policy_code", (Object)vo.getPromotionPolicyCode());
            if (this.promotionPolicyMapper.selectCount((Wrapper)wrapper) > 0) {
                throw new BusinessException("\u5df2\u5b58\u5728\u7684\u4fc3\u9500\u7f16\u7801[" + vo.getPromotionPolicyCode() + "]\u3002");
            }
            PromotionPolicyEntity temp = (PromotionPolicyEntity)((Object)CrmBeanUtil.copy((Object)vo, PromotionPolicyEntity.class));
            this.promotionPolicyMapper.insert((Object)temp);
            vo.setId(temp.getId());
        } else {
            PromotionPolicyEntity oldEntity = (PromotionPolicyEntity)((Object)this.promotionPolicyMapper.selectById((Serializable)((Object)vo.getId())));
            if (null == oldEntity) {
                throw new BusinessException("\u653f\u7b56\u6570\u636e\u4e0d\u5b58\u5728,ID=[" + vo.getId() + "]");
            }
            vo.setPromotionPolicyCode(oldEntity.getPromotionPolicyCode());
            this.doUpdate(vo);
        }
        this.promotionPolicyRuleService.refreshRule(vo);
        this.promotionPolicyScopeService.refreshScope(vo);
        this.promotionPolicyProductService.refreshProduct(vo);
    }

    @Override
    public List<PromotionPolicyInfoVo> loadPromotionPolicyInfoByCustAndProduct(String custCode, String productCode) {
        Set<String> promotionPolicyIdAsScopeContainableN;
        Set<String> promotionPolicyIdAsScopeContainableY;
        Set<String> promotionPolicyIdAsProduct;
        List<String> merged;
        if (StringUtils.isBlank((CharSequence)custCode) || StringUtils.isBlank((CharSequence)productCode)) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u5ba2\u6237\u548c\u5546\u54c1\u7f16\u7801");
        }
        MdmCustomerMsgRespVo customerMsgRespVo = this.loadCust(custCode);
        String orgCode = null;
        String channel = null;
        if (null != customerMsgRespVo) {
            orgCode = customerMsgRespVo.getCustomerOrgCode();
            channel = customerMsgRespVo.getChannel();
        }
        if (CollectionUtils.isEmpty(merged = this.merge(promotionPolicyIdAsProduct = this.promotionPolicyProductService.selectPromotionPolicyIdByProductCode(productCode), promotionPolicyIdAsScopeContainableY = this.promotionPolicyScopeService.selectPromotionPolicyIdByScopeCode(custCode, orgCode, channel, CommonConstant.GLOBAL.YesOrNo.Y), promotionPolicyIdAsScopeContainableN = this.promotionPolicyScopeService.selectPromotionPolicyIdByScopeCode(custCode, orgCode, channel, CommonConstant.GLOBAL.YesOrNo.N)))) {
            return Lists.newArrayList();
        }
        return CrmBeanUtil.copyList((List)this.promotionPolicyMapper.selectBatchIds(merged), PromotionPolicyInfoVo.class);
    }

    private MdmCustomerMsgRespVo loadCust(String custCode) {
        MdmCustomerMsgReqVo cusOrgVo = new MdmCustomerMsgReqVo();
        cusOrgVo.setCustomerCode(custCode);
        Result custResult = this.mdmCustomerMsgFeign.query(cusOrgVo);
        MdmCustomerMsgRespVo customerMsgRespVo = null;
        if (custResult.isSuccess() && null != custResult.getResult()) {
            customerMsgRespVo = (MdmCustomerMsgRespVo)custResult.getResult();
        }
        return customerMsgRespVo;
    }

    private List<String> merge(Set<String> promotionPolicyIds, Set<String> promotionPolicyIdAsScopeContainableY, Set<String> promotionPolicyIdAsScopeContainableN) {
        return promotionPolicyIds.stream().filter(v -> promotionPolicyIdAsScopeContainableY.contains(v)).collect(Collectors.toSet()).stream().filter(v -> !promotionPolicyIdAsScopeContainableN.contains(v)).collect(Collectors.toList());
    }

    @Override
    public Map<String, List<PromotionPolicyInfoVo>> loadPromotionPolicyInfoByCustAndProducts(String custCode, List<String> productCodes) {
        if (StringUtils.isBlank((CharSequence)custCode) || CollectionUtils.isEmpty(productCodes)) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u5ba2\u6237\u548c\u5546\u54c1\u7f16\u7801");
        }
        MdmCustomerMsgRespVo customerMsgRespVo = this.loadCust(custCode);
        String orgCode = null;
        String channel = null;
        if (null != customerMsgRespVo) {
            orgCode = customerMsgRespVo.getCustomerOrgCode();
            channel = customerMsgRespVo.getChannel();
        }
        Set<String> promotionPolicyIdAsScopeContainableY = this.promotionPolicyScopeService.selectPromotionPolicyIdByScopeCode(custCode, orgCode, channel, CommonConstant.GLOBAL.YesOrNo.Y);
        Set<String> promotionPolicyIdAsScopeContainableN = this.promotionPolicyScopeService.selectPromotionPolicyIdByScopeCode(custCode, orgCode, channel, CommonConstant.GLOBAL.YesOrNo.N);
        HashSet distinctProductCodes = Sets.newHashSet(productCodes);
        productCodes = Lists.newArrayList((Iterable)distinctProductCodes);
        List partitionList = Lists.partition((List)productCodes, (int)999);
        HashMap results = Maps.newHashMap();
        for (List list : partitionList) {
            List<PromotionPolicyProductEntity> promotionPolicyIdAsProduct = this.promotionPolicyProductService.selectPromotionPolicyIdByProductCodes(list);
            Map productCodeMapPromotionPolicyIds = promotionPolicyIdAsProduct.stream().collect(Collectors.groupingBy(PromotionPolicyProductEntity::getProductCode, Collectors.mapping(PromotionPolicyProductEntity::getPromotionPolicyId, Collectors.toSet())));
            HashMap custProductPromotionPolicyId = Maps.newHashMap();
            HashSet mergedPromotionPolicyId = Sets.newHashSet();
            for (Map.Entry entry : productCodeMapPromotionPolicyIds.entrySet()) {
                String productCode = entry.getKey();
                Set<String> promotionPolicyIds = entry.getValue();
                List<String> temp = this.merge(promotionPolicyIds, promotionPolicyIdAsScopeContainableY, promotionPolicyIdAsScopeContainableN);
                custProductPromotionPolicyId.put(productCode, temp);
                mergedPromotionPolicyId.addAll(temp);
            }
            results.putAll(this.loadPromotionPolicyInfoVo(mergedPromotionPolicyId, custProductPromotionPolicyId));
        }
        for (String productCode : distinctProductCodes) {
            if (results.containsKey(productCode)) continue;
            results.put(productCode, Lists.newArrayList());
        }
        return results;
    }

    private Map<String, List<PromotionPolicyInfoVo>> loadPromotionPolicyInfoVo(Set<String> mergedPromotionPolicyId, Map<String, List<String>> custProductPromotionPolicyId) {
        Map<Object, Object> infoVoMap = CollectionUtils.isEmpty(mergedPromotionPolicyId) ? Maps.newHashMap() : CrmBeanUtil.copyList((List)this.promotionPolicyMapper.selectBatchIds(mergedPromotionPolicyId), PromotionPolicyInfoVo.class).stream().collect(Collectors.toMap(UuidVo::getId, v -> v, (r, r2) -> r2));
        HashMap custProductPromotionPolicyInfoVo = Maps.newHashMap();
        for (Map.Entry<String, List<String>> entry : custProductPromotionPolicyId.entrySet()) {
            String productCode = entry.getKey();
            List<String> promotionPolicyIds = entry.getValue();
            ArrayList infoVos = Lists.newArrayList();
            promotionPolicyIds.forEach(v -> {
                if (infoVoMap.containsKey(v)) {
                    infoVos.add(infoVoMap.get(v));
                }
            });
            custProductPromotionPolicyInfoVo.put(productCode, infoVos);
        }
        return custProductPromotionPolicyInfoVo;
    }

    @Override
    public PromotionPolicyEditVo loadPolicyEditVo(String id, String templateId) {
        PromotionPolicyEditVo templateEditVo;
        if (StringUtils.isNotBlank((CharSequence)id)) {
            PromotionPolicyEntity entity = (PromotionPolicyEntity)((Object)this.promotionPolicyMapper.selectById((Serializable)((Object)id)));
            AssertUtils.isNotNull((Object)((Object)entity), (String)"\u672a\u52a0\u8f7d\u5230\u653f\u7b56\u6570\u636e");
            templateEditVo = (PromotionPolicyEditVo)CrmBeanUtil.copy((Object)((Object)entity), PromotionPolicyEditVo.class);
        } else {
            AssertUtils.isNotEmpty((String)templateId, (String)"\u8bf7\u9009\u62e9\u4fc3\u9500\u653f\u7b56\u6a21\u677f");
            templateEditVo = new PromotionPolicyEditVo();
            templateEditVo.setTemplateId(templateId);
        }
        this.promotionPolicyProductService.loadListForEditPromotionPolicy(templateEditVo);
        this.promotionPolicyScopeService.loadListForEditPromotionPolicy(templateEditVo);
        this.promotionPolicyRuleService.loadListForEditPromotionPolicy(templateEditVo);
        return templateEditVo;
    }

    private void doUpdate(PromotionPolicyEditReqVo vo) {
        PromotionPolicyEntity entity;
        Boolean timeActive = vo.timeActive();
        if (null == timeActive) {
            entity = (PromotionPolicyEntity)((Object)CrmBeanUtil.copy((Object)vo, PromotionPolicyEntity.class));
            this.promotionPolicyMapper.updateNullValById(entity);
        } else if (timeActive.booleanValue()) {
            if (System.currentTimeMillis() > vo.getEndTime()) {
                throw new BusinessException("\u6267\u884c\u4e2d\u7684\u653f\u7b56\u53ea\u53ef\u7f16\u8f91\u7ed3\u675f\u65f6\u95f4\u8c03\u6574\u81f3\u5f53\u524d\u65f6\u95f4\u4e4b\u540e\u7684\u65f6\u95f4\u70b9");
            }
            entity = new PromotionPolicyEntity();
            entity.setId(vo.getId());
            entity.setEndTime(vo.getEndTime());
        } else {
            throw new BusinessException("\u8be5\u653f\u7b56\u5df2\u7ed3\u675f\uff0c\u4e0d\u53ef\u4fee\u6539\uff01");
        }
        this.promotionPolicyMapper.updateById((Object)entity);
    }

    @Override
    public PageResult<PromotionPolicyVo> getPageList(PromotionPolicyQueryVo vo) {
        Page page = new Page((long)vo.getPageNum().intValue(), (long)vo.getPageSize().intValue());
        List<PromotionPolicyVo> list = this.promotionPolicyMapper.findList((Page<PromotionPolicyQueryVo>)page, vo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public List<PromotionPolicyEntity> getListByTemplate(String templateId, String templateCode) {
        QueryWrapper wrapper = Wrappers.query();
        if (StringUtils.isNotBlank((CharSequence)templateId)) {
            wrapper.in((Object)"template_id", new Object[]{templateId});
        } else if (StringUtils.isNotBlank((CharSequence)templateCode)) {
            wrapper.in((Object)"template_code", new Object[]{templateCode});
        }
        return this.promotionPolicyMapper.selectList((Wrapper)wrapper);
    }

    @Override
    public void del(List<String> promotionPolicyIds) {
        this.delCheck(promotionPolicyIds);
        this.promotionPolicyRuleService.delByPromotionPolicyIdOrCode(promotionPolicyIds, null);
        this.promotionPolicyScopeService.delByPromotionPolicyIdOrCode(promotionPolicyIds, null);
        this.promotionPolicyProductService.delByPromotionPolicyIdOrCode(promotionPolicyIds, null);
        this.promotionPolicyMapper.deleteBatchIds(promotionPolicyIds);
    }

    private void delCheck(List<String> promotionPolicyIds) {
        if (CollectionUtils.isEmpty(promotionPolicyIds)) {
            return;
        }
        List entities = this.promotionPolicyMapper.selectBatchIds(promotionPolicyIds);
        HashSet temp = Sets.newHashSet();
        for (PromotionPolicyEntity entity : entities) {
            Boolean timeActive = entity.timeActive();
            if (null == timeActive) continue;
            temp.add(entity.getPromotionPolicyCode());
        }
        if (CollectionUtils.isEmpty((Collection)temp)) {
            return;
        }
        throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c\u653f\u7b56[" + temp.stream().collect(Collectors.joining(", ")) + "]\u4e3a\u6267\u884c\u4e2d\u6216\u5df2\u7ed3\u675f\u72b6\u6001\uff01");
    }

    @Override
    public void enable(List<String> promotionPolicyIds) {
        if (CollectionUtils.isEmpty(promotionPolicyIds)) {
            return;
        }
        this.updateStatus(promotionPolicyIds, CrmEnableStatusEnum.ENABLE);
    }

    @Override
    public void disable(List<String> promotionPolicyIds) {
        if (CollectionUtils.isEmpty(promotionPolicyIds)) {
            return;
        }
        this.updateStatus(promotionPolicyIds, CrmEnableStatusEnum.DISABLE);
    }

    private void updateStatus(List<String> promotionPolicyIds, CrmEnableStatusEnum statusEnum) {
        QueryWrapper wrapper = Wrappers.query();
        wrapper.in((Object)"id", promotionPolicyIds);
        PromotionPolicyEntity entity = new PromotionPolicyEntity();
        entity.setEnableStatus(statusEnum.getCode());
        this.promotionPolicyMapper.update((Object)entity, (Wrapper)wrapper);
    }

    private void checkParams(PromotionPolicyEditReqVo vo) {
        AssertUtils.isNotNull((Object)vo, (String)"\u65e0\u6548\u53c2\u6570\uff0c\u8bf7\u91cd\u8bd5");
        AssertUtils.isNotEmpty((String)vo.getFirstOrder(), (String)"\u9996\u5355\u4f18\u60e0\u4e0d\u80fd\u4e3a\u7a7a!");
        AssertUtils.isNotNull((Object)vo.getBeginTime(), (String)"\u6709\u6548\u671f\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a!");
        AssertUtils.isNotNull((Object)vo.getEndTime(), (String)"\u6709\u6548\u671f\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a!");
        AssertUtils.isNotEmpty((String)vo.getDescription(), (String)"\u4fc3\u9500\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a!");
        AssertUtils.isNotEmpty((String)vo.getPromotionPolicyCode(), (String)"\u4fc3\u9500\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        AssertUtils.isNotEmpty((String)vo.getPromotionPolicyName(), (String)"\u4fc3\u9500\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        AssertUtils.isNotEmpty((String)vo.getTemplateId(), (String)"\u6a21\u677fID\u4e0d\u80fd\u4e3a\u7a7a!");
        AssertUtils.isNotEmpty((String)vo.getTemplateCode(), (String)"\u6a21\u677f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        AssertUtils.isNotEmpty((String)vo.getTemplateName(), (String)"\u6a21\u677f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        this.checkProductParams(vo);
        this.checkRuleParams(vo);
        this.checkScopeParams(vo);
    }

    private void checkRuleParams(PromotionPolicyEditReqVo vo) {
        PromotionPolicyEditReqVo.PromotionPolicyRule rule = vo.getPromotionPolicyRule();
        AssertUtils.isNotNull((Object)rule, (String)"\u4fc3\u9500\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a!");
        AssertUtils.isNotEmpty((Collection)rule.getRulesAsCalculate(), (String)"\u4fc3\u9500\u89c4\u5219-\u8ba1\u7b97\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a!");
        AssertUtils.isNotEmpty((Collection)rule.getRulesAsCondition(), (String)"\u4fc3\u9500\u89c4\u5219-\u6ee1\u8db3\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a!");
        List allRules = vo.takeAllRules();
        allRules.forEach(v -> AssertUtils.isNotEmpty((String)v.getPromotionRuleId(), (String)"\u89c4\u5219ID\u4e0d\u80fd\u4e3a\u7a7a!"));
    }

    private void checkProductParams(PromotionPolicyEditReqVo vo) {
        PromotionPolicyEditReqVo.PromotionPolicyProduct product = vo.getPromotionPolicyProduct();
        AssertUtils.isNotNull((Object)product, (String)"\u4fc3\u9500\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a!");
        AssertUtils.isNotEmpty((Collection)product.getProductsCurrentY(), (String)"\u4fc3\u9500\u5546\u54c1\u672c\u54c1\u4e0d\u80fd\u4e3a\u7a7a!");
        List allProducts = vo.takeAllProducts();
        allProducts.forEach(v -> {
            AssertUtils.isNotEmpty((String)v.getProductCode(), (String)"\u4fc3\u9500\u5546\u54c1-\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
            AssertUtils.isNotEmpty((String)v.getProductName(), (String)"\u4fc3\u9500\u5546\u54c1-\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        });
    }

    private void checkScopeParams(PromotionPolicyEditReqVo vo) {
        PromotionPolicyEditReqVo.PromotionPolicyScope product = vo.getPromotionPolicyScope();
        List allScopes = vo.takeAllScopes();
        allScopes.forEach(v -> {
            AssertUtils.isNotEmpty((String)v.getScopeCode(), (String)"\u4fc3\u9500\u8303\u56f4-\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
            AssertUtils.isNotEmpty((String)v.getScopeName(), (String)"\u4fc3\u9500\u8303\u56f4-\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
            AssertUtils.isNotEmpty((String)v.getScopeType(), (String)"\u4fc3\u9500\u8303\u56f4-\u8303\u56f4\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!");
        });
    }

    @Override
    public List<PromotionPolicyConfigInfo> loadPromotionPolicyConfigInfo(String custCode, String productCode) {
        List<PromotionPolicyInfoVo> policys = this.loadPromotionPolicyInfoByCustAndProduct(custCode, productCode);
        ArrayList infos = Lists.newArrayList();
        for (PromotionPolicyInfoVo infoVo : policys) {
            List<PromotionPolicyRuleEntity> promotionPolicyRules = this.promotionPolicyRuleService.getRuleByPromotionPolicyIdOrCode(infoVo.getId(), null);
            Map<String, List<PromotionPolicyRuleEntity>> rulesMapAsPolicyRules = promotionPolicyRules.stream().collect(Collectors.groupingBy(PromotionPolicyRuleEntity::getRuleType));
            PromotionPolicyRuleEntity conditionAsPolicyRules = rulesMapAsPolicyRules.get(PromotionRuleVo.RULE_TYPE.condition.name()).get(0);
            PromotionPolicyRuleEntity calculateAsPolicyRules = rulesMapAsPolicyRules.get(PromotionRuleVo.RULE_TYPE.calculate.name()).get(0);
            List<PromotionPolicyRuleEntity> limitedAsPolicyRules = rulesMapAsPolicyRules.get(PromotionRuleVo.RULE_TYPE.limited.name());
            Set<String> ruleIds = promotionPolicyRules.stream().map(PromotionPolicyRuleEntity::getPromotionRuleId).collect(Collectors.toSet());
            Map<String, List<PromotionRuleEntity>> rulesMap = this.promotionRuleService.getListByIds(ruleIds).stream().collect(Collectors.groupingBy(PromotionRuleEntity::getRuleType));
            PromotionRuleEntity condition = rulesMap.get(PromotionRuleVo.RULE_TYPE.condition.name()).get(0);
            PromotionRuleEntity calculate = rulesMap.get(PromotionRuleVo.RULE_TYPE.calculate.name()).get(0);
            Map<String, PromotionRuleEntity> limited = rulesMap.get(PromotionRuleVo.RULE_TYPE.limited.name()).stream().collect(Collectors.toMap(PromotionRuleEntity::getRuleCode, v -> v, (t, t2) -> t2));
            PromotionPolicyRuleVo calculateRuleVo = (PromotionPolicyRuleVo)CrmBeanUtil.copy((Object)((Object)calculateAsPolicyRules), PromotionPolicyRuleVo.class);
            calculateRuleVo.setFuncBody(calculate.getFuncBody());
            PromotionPolicyRuleVo conditionRuleVo = (PromotionPolicyRuleVo)CrmBeanUtil.copy((Object)((Object)conditionAsPolicyRules), PromotionPolicyRuleVo.class);
            conditionRuleVo.setFuncBody(condition.getFuncBody());
            List limitedRuleVo = CrmBeanUtil.copyList(limitedAsPolicyRules, PromotionPolicyRuleVo.class);
            limitedRuleVo.forEach(v -> {
                PromotionRuleEntity temp = (PromotionRuleEntity)((Object)((Object)limited.get(v.getRuleCode())));
                if (null != temp) {
                    v.setFuncBody(temp.getFuncBody());
                }
            });
            PromotionPolicyConfigInfo promotionPolicyConfigInfo = new PromotionPolicyConfigInfo();
            promotionPolicyConfigInfo.setPromotionPolicyInfoVo(infoVo);
            promotionPolicyConfigInfo.setCalculate(calculateRuleVo);
            promotionPolicyConfigInfo.setCondition(conditionRuleVo);
            promotionPolicyConfigInfo.setLimited(limitedRuleVo);
            infos.add(promotionPolicyConfigInfo);
        }
        return infos;
    }

    @Override
    public ShellResult testRunRule(BasePromotionPolicyCalculateShellParam shellParam) {
        return GroovyShellUtil.runShell((BaseGroovyShellParam)shellParam);
    }
}

