/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.salestarget.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.dms.salestarget.SalesMonthTargetVo;
import com.biz.crm.nebular.dms.salestarget.SalesTargetVo;
import com.biz.crm.salestarget.entity.SalesTargetEntity;
import com.biz.crm.salestarget.mapper.SalesTargetMapper;
import com.biz.crm.salestarget.service.SalesMonthTargetService;
import com.biz.crm.salestarget.service.SalesTargetService;
import com.biz.crm.salestarget.utils.SalesMonthTargetUtil;
import com.biz.crm.salestarget.utils.SalesTargetUtil;
import com.biz.crm.util.ValidateUtils;
import com.bizunited.platform.common.vo.UuidVo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@ConditionalOnMissingBean(name={"salesTargetServiceExpand"})
@Service(value="salesTargetService")
public class SalesTargetServiceImpl
extends ServiceImpl<SalesTargetMapper, SalesTargetEntity>
implements SalesTargetService {
    @Autowired
    private SalesTargetMapper salesTargetMapper;
    @Resource
    private SalesMonthTargetService salesMonthTargetService;

    @Override
    @Transactional
    public void add(SalesTargetVo salesTargetVo) {
        List entities;
        SalesTargetUtil.validateAddParam(salesTargetVo);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"cus_code", (Object)salesTargetVo.getCusCode());
        wrapper.eq((Object)"target_year", (Object)salesTargetVo.getTargetYear());
        if (salesTargetVo.getType().intValue() == SalesTargetUtil.TYPE.GOODS.getCode().intValue()) {
            wrapper.eq((Object)"goods_code", (Object)salesTargetVo.getGoodsCode());
        }
        if (salesTargetVo.getType().intValue() == SalesTargetUtil.TYPE.PRODUCTLQVEL.getCode().intValue()) {
            wrapper.eq((Object)"product_level_code", (Object)salesTargetVo.getProductLevelCode());
        }
        if (!CollectionUtils.isEmpty((Collection)(entities = this.salesTargetMapper.selectList((Wrapper)wrapper)))) {
            throw new BusinessException("\u91cd\u590d\u6dfb\u52a0!");
        }
        SalesTargetEntity entity = SalesTargetUtil.packageEntityForAdd(salesTargetVo);
        this.salesTargetMapper.insert((Object)entity);
        this.salesMonthTargetService.add(entity, salesTargetVo.getSalesMonthTargetVo());
    }

    @Override
    @Transactional
    public void edit(SalesTargetVo salesTargetVo) {
        ValidateUtils.validate((Object)salesTargetVo.getId(), (String)"\u8bf7\u6307\u5b9a\u8981\u7f16\u8f91\u7684\u9500\u552e\u76ee\u6807!");
        SalesTargetEntity entity = (SalesTargetEntity)((Object)this.salesTargetMapper.selectById((Serializable)((Object)salesTargetVo.getId())));
        ValidateUtils.validate((Object)((Object)entity), (String)"\u60a8\u8981\u7f16\u8f91\u7684\u9500\u552e\u76ee\u6807\u4e0d\u5b58\u5728\u6216\u8005\u5df2\u7ecf\u88ab\u5220\u9664!");
        entity.setTargetNum(SalesMonthTargetUtil.countTargetNum(salesTargetVo.getSalesMonthTargetVo()));
        this.salesTargetMapper.updateById((Object)entity);
        this.salesMonthTargetService.update(salesTargetVo.getSalesMonthTargetVo());
    }

    @Override
    public SalesTargetVo findById(String id) {
        SalesTargetVo vo = null;
        ValidateUtils.validate((Object)id, (String)"\u8bf7\u6307\u5b9a\u9700\u8981\u67e5\u8be2\u7684\u9500\u552e\u76ee\u6807\uff01");
        SalesTargetEntity entity = (SalesTargetEntity)((Object)this.salesTargetMapper.selectById((Serializable)((Object)id)));
        if (null == entity) {
            return vo;
        }
        vo = new SalesTargetVo();
        BeanUtils.copyProperties((Object)((Object)entity), (Object)vo);
        vo.setTargetNumStr(vo.getTargetNum().stripTrailingZeros().toPlainString());
        vo.setSalesMonthTargetVo(this.salesMonthTargetService.findBySalesTargetId(vo.getId()));
        return vo;
    }

    @Override
    public SalesTargetVo findDetailsByFormInstanceId(String formInstanceId) {
        SalesTargetVo vo = null;
        ValidateUtils.validate((Object)formInstanceId, (String)"\u8bf7\u6307\u5b9a\u9700\u8981\u67e5\u8be2\u7684\u9500\u552e\u76ee\u6807\uff01");
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"form_instance_id", (Object)formInstanceId);
        List entities = this.salesTargetMapper.selectList((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)entities)) {
            return vo;
        }
        SalesTargetEntity entity = (SalesTargetEntity)((Object)entities.get(0));
        vo = new SalesTargetVo();
        BeanUtils.copyProperties((Object)((Object)entity), (Object)vo);
        vo.setTargetNumStr(vo.getTargetNum().stripTrailingZeros().toPlainString());
        vo.setSalesMonthTargetVo(this.salesMonthTargetService.findBySalesTargetId(entity.getId()));
        return vo;
    }

    @Override
    public PageResult<SalesTargetVo> list(SalesTargetVo salesTargetVo) {
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().like(!StringUtils.isEmpty((Object)salesTargetVo.getCusName()), (Object)"cus_name", (Object)salesTargetVo.getCusName())).eq(!StringUtils.isEmpty((Object)salesTargetVo.getCusCode()), (Object)"cus_code", (Object)salesTargetVo.getCusCode())).like(!StringUtils.isEmpty((Object)salesTargetVo.getCusOrgName()), (Object)"cus_org_name", (Object)salesTargetVo.getCusOrgName())).eq(!StringUtils.isEmpty((Object)salesTargetVo.getCusOrgCode()), (Object)"cus_org_code", (Object)salesTargetVo.getCusOrgCode())).like(!StringUtils.isEmpty((Object)salesTargetVo.getCusChannelName()), (Object)"cus_channel_name", (Object)salesTargetVo.getCusChannelName())).eq(!StringUtils.isEmpty((Object)salesTargetVo.getCusChannelCode()), (Object)"cus_channel_code", (Object)salesTargetVo.getCusChannelCode())).eq(null != salesTargetVo.getType(), (Object)"type", (Object)salesTargetVo.getType())).eq(null != salesTargetVo.getTargetYear(), (Object)"target_year", (Object)salesTargetVo.getTargetYear())).eq(!StringUtils.isEmpty((Object)salesTargetVo.getName()), (Object)"name", (Object)salesTargetVo.getName())).like(!StringUtils.isEmpty((Object)salesTargetVo.getGoodsName()), (Object)"goods_name", (Object)salesTargetVo.getGoodsName())).eq(!StringUtils.isEmpty((Object)salesTargetVo.getGoodsCode()), (Object)"goods_code", (Object)salesTargetVo.getGoodsCode())).like(!StringUtils.isEmpty((Object)salesTargetVo.getProductLevelName()), (Object)"product_level_name", (Object)salesTargetVo.getProductLevelName())).eq(!StringUtils.isEmpty((Object)salesTargetVo.getProductLevelCode()), (Object)"product_level_code", (Object)salesTargetVo.getProductLevelCode())).orderByDesc((Object[])new String[]{"create_date", "create_date_second"});
        Page page = new Page((long)salesTargetVo.getPageNum().intValue(), (long)salesTargetVo.getPageSize().intValue());
        List<SalesTargetVo> list = this.salesTargetMapper.list(page, (QueryWrapper<SalesTargetVo>)wrapper);
        if (!CollectionUtils.isEmpty(list)) {
            Map<String, SalesMonthTargetVo> detailMap = this.salesMonthTargetService.findBySalesTargetIds(list.stream().map(UuidVo::getId).collect(Collectors.toList()));
            for (SalesTargetVo vo : list) {
                vo.setTargetNumStr(vo.getTargetNum().stripTrailingZeros().toPlainString());
                vo.setSalesMonthTargetVo(detailMap.get(vo.getId()));
            }
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @Transactional
    public void delByIds(ArrayList<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        this.salesTargetMapper.deleteBatchIds(ids);
    }

    @Override
    @Transactional
    public void delByParam(SalesTargetVo salesTargetVo) {
        if (null == salesTargetVo) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u67e5\u8be2\u6761\u4ef6!");
        }
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().like(!StringUtils.isEmpty((Object)salesTargetVo.getCusName()), (Object)"cus_name", (Object)salesTargetVo.getCusName())).eq(!StringUtils.isEmpty((Object)salesTargetVo.getCusCode()), (Object)"cus_code", (Object)salesTargetVo.getCusCode())).like(!StringUtils.isEmpty((Object)salesTargetVo.getCusOrgName()), (Object)"cus_org_name", (Object)salesTargetVo.getCusOrgName())).eq(!StringUtils.isEmpty((Object)salesTargetVo.getCusOrgCode()), (Object)"cus_org_code", (Object)salesTargetVo.getCusOrgCode())).like(!StringUtils.isEmpty((Object)salesTargetVo.getCusChannelName()), (Object)"cus_channel_name", (Object)salesTargetVo.getCusChannelName())).eq(!StringUtils.isEmpty((Object)salesTargetVo.getCusChannelCode()), (Object)"cus_channel_code", (Object)salesTargetVo.getCusChannelCode())).eq(null != salesTargetVo.getType(), (Object)"type", (Object)salesTargetVo.getType())).eq(null != salesTargetVo.getTargetYear(), (Object)"target_year", (Object)salesTargetVo.getTargetYear())).like(!StringUtils.isEmpty((Object)salesTargetVo.getGoodsName()), (Object)"goods_name", (Object)salesTargetVo.getGoodsName())).eq(!StringUtils.isEmpty((Object)salesTargetVo.getGoodsCode()), (Object)"goods_code", (Object)salesTargetVo.getGoodsCode())).like(!StringUtils.isEmpty((Object)salesTargetVo.getProductLevelName()), (Object)"product_level_name", (Object)salesTargetVo.getProductLevelName())).eq(!StringUtils.isEmpty((Object)salesTargetVo.getProductLevelCode()), (Object)"product_level_code", (Object)salesTargetVo.getProductLevelCode());
        this.salesTargetMapper.delete((Wrapper)wrapper);
    }
}

